#include "megcore_atlas.h"

#include "src/atlas/megcore/computing_context.hpp"
#include "src/atlas/megcore/device_context.hpp"
#include "src/common/megcore/public_api/computing.hpp"
#include "src/common/megcore/public_api/device.hpp"
#include "src/common/utils.h"

using namespace megcore;

megcoreStatus_t megcore::createAtlasDeviceHandleWithGlobalInitStatus(
        megcoreDeviceHandle_t* devHandle, int deviceID, unsigned int flags,
        bool global_initialized) {
    auto content = megdnn::make_unique<atlas::AtlasDeviceContext>(
            deviceID, flags, global_initialized);
    auto& ctx = *devHandle;
    ctx = new megcoreDeviceContext;
    ctx->content = std::move(content);
    return megcoreSuccess;
}

megcoreStatus_t megcore::createComputingHandleWithAtlasContext(
        megcoreComputingHandle_t* compHandle, megcoreDeviceHandle_t devHandle,
        unsigned int flags, const AtlasContext& ctx) {
    MEGDNN_MARK_USED_VAR(flags);
    megdnn_assert(flags == 0);
    auto content =
            megdnn::make_unique<atlas::AtlasComputingContext>(devHandle, flags, ctx);
    auto& H = *compHandle;
    H = new megcoreComputingContext;
    H->content = std::move(content);
    return megcoreSuccess;
}

megcoreStatus_t megcore::getAtlasContext(
        megcoreComputingHandle_t handle, AtlasContext* ctx) {
    auto&& H = handle;
    megdnn_assert(H);
    megcoreDeviceHandle_t dev_handle = H->content->dev_handle();
    megcorePlatform_t platform;
    megcoreGetPlatform(dev_handle, &platform);
    megdnn_assert(platform == megcorePlatformAtlas);
    auto context =
            static_cast<megcore::atlas::AtlasComputingContext*>(H->content.get());
    *ctx = context->context();
    return megcoreSuccess;
}

const char* megcore::atlas::get_error_str(aclError error) {
#define ERROR(_err) \
    case _err:      \
        return #_err;

    switch (error) {
        ERROR(ACL_ERROR_NONE);
        ERROR(ACL_ERROR_INVALID_PARAM);
        ERROR(ACL_ERROR_UNINITIALIZE);
        ERROR(ACL_ERROR_REPEAT_INITIALIZE);
        ERROR(ACL_ERROR_INVALID_FILE);
        ERROR(ACL_ERROR_WRITE_FILE);
        ERROR(ACL_ERROR_INVALID_FILE_SIZE);
        ERROR(ACL_ERROR_PARSE_FILE);
        ERROR(ACL_ERROR_FILE_MISSING_ATTR);
        ERROR(ACL_ERROR_FILE_ATTR_INVALID);
        ERROR(ACL_ERROR_INVALID_DUMP_CONFIG);
        ERROR(ACL_ERROR_INVALID_PROFILING_CONFIG);
        ERROR(ACL_ERROR_INVALID_MODEL_ID);
        ERROR(ACL_ERROR_DESERIALIZE_MODEL);
        ERROR(ACL_ERROR_PARSE_MODEL);
        ERROR(ACL_ERROR_READ_MODEL_FAILURE);
        ERROR(ACL_ERROR_MODEL_SIZE_INVALID);
        ERROR(ACL_ERROR_MODEL_MISSING_ATTR);
        ERROR(ACL_ERROR_MODEL_INPUT_NOT_MATCH);
        ERROR(ACL_ERROR_MODEL_OUTPUT_NOT_MATCH);
        ERROR(ACL_ERROR_MODEL_NOT_DYNAMIC);
        ERROR(ACL_ERROR_OP_TYPE_NOT_MATCH);
        ERROR(ACL_ERROR_OP_INPUT_NOT_MATCH);
        ERROR(ACL_ERROR_OP_OUTPUT_NOT_MATCH);
        ERROR(ACL_ERROR_OP_ATTR_NOT_MATCH);
        ERROR(ACL_ERROR_OP_NOT_FOUND);
        ERROR(ACL_ERROR_OP_LOAD_FAILED);
        ERROR(ACL_ERROR_UNSUPPORTED_DATA_TYPE);
        ERROR(ACL_ERROR_FORMAT_NOT_MATCH);
        ERROR(ACL_ERROR_BIN_SELECTOR_NOT_REGISTERED);
        ERROR(ACL_ERROR_KERNEL_NOT_FOUND);
        ERROR(ACL_ERROR_BIN_SELECTOR_ALREADY_REGISTERED);
        ERROR(ACL_ERROR_KERNEL_ALREADY_REGISTERED);
        ERROR(ACL_ERROR_INVALID_QUEUE_ID);
        ERROR(ACL_ERROR_REPEAT_SUBSCRIBE);
        ERROR(ACL_ERROR_STREAM_NOT_SUBSCRIBE);
        ERROR(ACL_ERROR_THREAD_NOT_SUBSCRIBE);
        ERROR(ACL_ERROR_WAIT_CALLBACK_TIMEOUT);
        ERROR(ACL_ERROR_REPEAT_FINALIZE);
        ERROR(ACL_ERROR_NOT_STATIC_AIPP);
        ERROR(ACL_ERROR_COMPILING_STUB_MODE);
        ERROR(ACL_ERROR_GROUP_NOT_SET);
        ERROR(ACL_ERROR_GROUP_NOT_CREATE);
        ERROR(ACL_ERROR_PROF_ALREADY_RUN);
        ERROR(ACL_ERROR_PROF_NOT_RUN);
        ERROR(ACL_ERROR_DUMP_ALREADY_RUN);
        ERROR(ACL_ERROR_DUMP_NOT_RUN);
        ERROR(ACL_ERROR_PROF_REPEAT_SUBSCRIBE);
        ERROR(ACL_ERROR_PROF_API_CONFLICT);
        ERROR(ACL_ERROR_INVALID_MAX_OPQUEUE_NUM_CONFIG);
        ERROR(ACL_ERROR_INVALID_OPP_PATH);
        ERROR(ACL_ERROR_OP_UNSUPPORTED_DYNAMIC);
        ERROR(ACL_ERROR_RELATIVE_RESOURCE_NOT_CLEARED);
        ERROR(ACL_ERROR_BAD_ALLOC);
        ERROR(ACL_ERROR_API_NOT_SUPPORT);
        ERROR(ACL_ERROR_INVALID_DEVICE);
        ERROR(ACL_ERROR_MEMORY_ADDRESS_UNALIGNED);
        ERROR(ACL_ERROR_RESOURCE_NOT_MATCH);
        ERROR(ACL_ERROR_INVALID_RESOURCE_HANDLE);
        ERROR(ACL_ERROR_FEATURE_UNSUPPORTED);
        ERROR(ACL_ERROR_PROF_MODULES_UNSUPPORTED);
        ERROR(ACL_ERROR_STORAGE_OVER_LIMIT);
        ERROR(ACL_ERROR_INTERNAL_ERROR);
        ERROR(ACL_ERROR_FAILURE);
        ERROR(ACL_ERROR_GE_FAILURE);
        ERROR(ACL_ERROR_RT_FAILURE);
        ERROR(ACL_ERROR_DRV_FAILURE);
        ERROR(ACL_ERROR_PROFILING_FAILURE);

        ERROR(ACL_ERROR_GE_PARAM_INVALID);
        ERROR(ACL_ERROR_GE_EXEC_NOT_INIT);
        ERROR(ACL_ERROR_GE_EXEC_MODEL_PATH_INVALID);
        ERROR(ACL_ERROR_GE_EXEC_MODEL_ID_INVALID);
        ERROR(ACL_ERROR_GE_EXEC_MODEL_DATA_SIZE_INVALID);
        ERROR(ACL_ERROR_GE_EXEC_MODEL_ADDR_INVALID);
        ERROR(ACL_ERROR_GE_EXEC_MODEL_QUEUE_ID_INVALID);
        ERROR(ACL_ERROR_GE_EXEC_LOAD_MODEL_REPEATED);
        ERROR(ACL_ERROR_GE_DYNAMIC_INPUT_ADDR_INVALID);
        ERROR(ACL_ERROR_GE_DYNAMIC_INPUT_LENGTH_INVALID);
        ERROR(ACL_ERROR_GE_DYNAMIC_BATCH_SIZE_INVALID);
        ERROR(ACL_ERROR_GE_AIPP_BATCH_EMPTY);
        ERROR(ACL_ERROR_GE_AIPP_NOT_EXIST);
        ERROR(ACL_ERROR_GE_AIPP_MODE_INVALID);
        ERROR(ACL_ERROR_GE_OP_TASK_TYPE_INVALID);
        ERROR(ACL_ERROR_GE_OP_KERNEL_TYPE_INVALID);
        ERROR(ACL_ERROR_GE_PLGMGR_PATH_INVALID);
        ERROR(ACL_ERROR_GE_FORMAT_INVALID);
        ERROR(ACL_ERROR_GE_SHAPE_INVALID);
        ERROR(ACL_ERROR_GE_DATATYPE_INVALID);
        ERROR(ACL_ERROR_GE_MEMORY_ALLOCATION);
        ERROR(ACL_ERROR_GE_MEMORY_OPERATE_FAILED);
        ERROR(ACL_ERROR_GE_INTERNAL_ERROR);
        ERROR(ACL_ERROR_GE_LOAD_MODEL);
        ERROR(ACL_ERROR_GE_EXEC_LOAD_MODEL_PARTITION_FAILED);
        ERROR(ACL_ERROR_GE_EXEC_LOAD_WEIGHT_PARTITION_FAILED);
        ERROR(ACL_ERROR_GE_EXEC_LOAD_TASK_PARTITION_FAILED);
        ERROR(ACL_ERROR_GE_EXEC_LOAD_KERNEL_PARTITION_FAILED);
        ERROR(ACL_ERROR_GE_EXEC_RELEASE_MODEL_DATA);
        ERROR(ACL_ERROR_GE_COMMAND_HANDLE);
        ERROR(ACL_ERROR_GE_GET_TENSOR_INFO);
        ERROR(ACL_ERROR_GE_UNLOAD_MODEL);

        ERROR(ACL_ERROR_RT_PARAM_INVALID);
        ERROR(ACL_ERROR_RT_INVALID_DEVICEID);
        ERROR(ACL_ERROR_RT_CONTEXT_NULL);
        ERROR(ACL_ERROR_RT_STREAM_CONTEXT);
        ERROR(ACL_ERROR_RT_MODEL_CONTEXT);
        ERROR(ACL_ERROR_RT_STREAM_MODEL);
        ERROR(ACL_ERROR_RT_EVENT_TIMESTAMP_INVALID);
        ERROR(ACL_ERROR_RT_EVENT_TIMESTAMP_REVERSAL);
        ERROR(ACL_ERROR_RT_ADDR_UNALIGNED);
        ERROR(ACL_ERROR_RT_FILE_OPEN);
        ERROR(ACL_ERROR_RT_FILE_WRITE);
        ERROR(ACL_ERROR_RT_STREAM_SUBSCRIBE);
        ERROR(ACL_ERROR_RT_THREAD_SUBSCRIBE);
        ERROR(ACL_ERROR_RT_GROUP_NOT_SET);
        ERROR(ACL_ERROR_RT_GROUP_NOT_CREATE);
        ERROR(ACL_ERROR_RT_STREAM_NO_CB_REG);
        ERROR(ACL_ERROR_RT_INVALID_MEMORY_TYPE);
        ERROR(ACL_ERROR_RT_INVALID_HANDLE);
        ERROR(ACL_ERROR_RT_INVALID_MALLOC_TYPE);
        ERROR(ACL_ERROR_RT_WAIT_TIMEOUT);
        ERROR(ACL_ERROR_RT_TASK_TIMEOUT);
        ERROR(ACL_ERROR_RT_FEATURE_NOT_SUPPORT);
        ERROR(ACL_ERROR_RT_MEMORY_ALLOCATION);
        ERROR(ACL_ERROR_RT_MEMORY_FREE);
        ERROR(ACL_ERROR_RT_AICORE_OVER_FLOW);
        ERROR(ACL_ERROR_RT_NO_DEVICE);
        ERROR(ACL_ERROR_RT_RESOURCE_ALLOC_FAIL);
        ERROR(ACL_ERROR_RT_NO_PERMISSION);
        ERROR(ACL_ERROR_RT_NO_EVENT_RESOURCE);
        ERROR(ACL_ERROR_RT_NO_STREAM_RESOURCE);
        ERROR(ACL_ERROR_RT_NO_NOTIFY_RESOURCE);
        ERROR(ACL_ERROR_RT_NO_MODEL_RESOURCE);
        ERROR(ACL_ERROR_RT_NO_CDQ_RESOURCE);
        ERROR(ACL_ERROR_RT_OVER_LIMIT);
        ERROR(ACL_ERROR_RT_QUEUE_EMPTY);
        ERROR(ACL_ERROR_RT_QUEUE_FULL);
        ERROR(ACL_ERROR_RT_REPEATED_INIT);
        ERROR(ACL_ERROR_RT_AIVEC_OVER_FLOW);
        ERROR(ACL_ERROR_RT_INTERNAL_ERROR);
        ERROR(ACL_ERROR_RT_TS_ERROR);
        ERROR(ACL_ERROR_RT_STREAM_TASK_FULL);
        ERROR(ACL_ERROR_RT_STREAM_TASK_EMPTY);
        ERROR(ACL_ERROR_RT_STREAM_NOT_COMPLETE);
        ERROR(ACL_ERROR_RT_END_OF_SEQUENCE);
        ERROR(ACL_ERROR_RT_EVENT_NOT_COMPLETE);
        ERROR(ACL_ERROR_RT_CONTEXT_RELEASE_ERROR);
        ERROR(ACL_ERROR_RT_SOC_VERSION);
        ERROR(ACL_ERROR_RT_TASK_TYPE_NOT_SUPPORT);
        ERROR(ACL_ERROR_RT_LOST_HEARTBEAT);
        ERROR(ACL_ERROR_RT_MODEL_EXECUTE);
        ERROR(ACL_ERROR_RT_REPORT_TIMEOUT);
        ERROR(ACL_ERROR_RT_SYS_DMA);
        ERROR(ACL_ERROR_RT_AICORE_TIMEOUT);
        ERROR(ACL_ERROR_RT_AICORE_EXCEPTION);
        ERROR(ACL_ERROR_RT_AICORE_TRAP_EXCEPTION);
        ERROR(ACL_ERROR_RT_AICPU_TIMEOUT);
        ERROR(ACL_ERROR_RT_AICPU_EXCEPTION);
        ERROR(ACL_ERROR_RT_AICPU_DATADUMP_RSP_ERR);
        ERROR(ACL_ERROR_RT_AICPU_MODEL_RSP_ERR);
        ERROR(ACL_ERROR_RT_PROFILING_ERROR);
        ERROR(ACL_ERROR_RT_IPC_ERROR);
        ERROR(ACL_ERROR_RT_MODEL_ABORT_NORMAL);
        ERROR(ACL_ERROR_RT_KERNEL_UNREGISTERING);
        ERROR(ACL_ERROR_RT_RINGBUFFER_NOT_INIT);
        ERROR(ACL_ERROR_RT_RINGBUFFER_NO_DATA);
        ERROR(ACL_ERROR_RT_KERNEL_LOOKUP);
        ERROR(ACL_ERROR_RT_KERNEL_DUPLICATE);
        ERROR(ACL_ERROR_RT_DEBUG_REGISTER_FAIL);
        ERROR(ACL_ERROR_RT_DEBUG_UNREGISTER_FAIL);
        ERROR(ACL_ERROR_RT_LABEL_CONTEXT);
        ERROR(ACL_ERROR_RT_PROGRAM_USE_OUT);
        ERROR(ACL_ERROR_RT_DEV_SETUP_ERROR);
        ERROR(ACL_ERROR_RT_VECTOR_CORE_TIMEOUT);
        ERROR(ACL_ERROR_RT_VECTOR_CORE_EXCEPTION);
        ERROR(ACL_ERROR_RT_VECTOR_CORE_TRAP_EXCEPTION);
        ERROR(ACL_ERROR_RT_CDQ_BATCH_ABNORMAL);
        ERROR(ACL_ERROR_RT_DIE_MODE_CHANGE_ERROR);
        ERROR(ACL_ERROR_RT_DIE_SET_ERROR);
        ERROR(ACL_ERROR_RT_INVALID_DIEID);
        ERROR(ACL_ERROR_RT_DIE_MODE_NOT_SET);
        ERROR(ACL_ERROR_RT_DRV_INTERNAL_ERROR);
        ERROR(ACL_ERROR_RT_AICPU_INTERNAL_ERROR);
        ERROR(ACL_ERROR_RT_SOCKET_CLOSE);

        default:
            return "unknown error";
    }
#undef ERROR
}

// vim: syntax=cpp.doxygen
