# 智慧养老平台（Vue3 + Vite）

## 项目简介
本项目是基于 Vue3 + Vite + Element Plus 的"智慧养老"主题平台，涵盖登录注册、新闻资讯、商品展示、社区互动、服务预约等多模块，界面美观、交互丰富，适合课程设计、项目考核和实际展示。

## 主要功能
- **首页**：轮播图、健康打卡、欢迎文案
- **商品页**：商品卡片、父子组件、插槽、智能设备推荐
- **新闻页**：新闻列表、详情页、配图/视频、评论区、相关文章推荐
- **社区页**：社区活动、家属留言
- **登录/注册**：正则验证、记住我、验证码、第三方登录、自适应美化
- **服务预约**：表单填写、预约历史
- **紧急呼叫**：右下角悬浮按钮

## 技术栈
- Vue3 + Vite
- vue-router
- Element Plus
- 本地存储（localStorage）数据持久化
- 响应式布局与页面美化

## 目录结构
```
├── public/assets         # 图片、视频等素材
├── src/
│   ├── components/      # 公共组件
│   ├── views/           # 页面视图
│   ├── router/          # 路由配置
│   └── main.js          # 入口文件
├── package.json
├── README.md
└── ...
```

## 运行方法
1. 安装依赖
   ```bash
   npm install
   # 或 yarn install
   ```
2. 启动开发环境
   ```bash
   npm run dev
   # 或 yarn dev
   ```
3. 打开浏览器访问 [http://localhost:5173](http://localhost:5173)

## 主要特色与考核点
- 结构规范，代码分层清晰
- 路由、父子组件、插槽、正则验证等 Vue3 核心考点
- 页面美观，主色调统一，动画丰富，响应式适配
- 本地存储实现健康打卡、评论、预约、留言等数据持久化
- 健壮性处理，异常友好提示
- 素材管理与路径规范

## 扩展建议
- 可接入后端API实现数据同步
- 增加更多智能设备、健康服务、社区互动功能
- 优化移动端体验

## 截图与演示
（请自行补充项目截图、演示视频等）

---
如有问题欢迎交流！ 