import glob
import os
import subprocess
import sys

import main

def open():
    # 指定文件夹路径和应用程序名称
    folder_path = r'D:\DltCheck\DltViewerSDK'  #r前缀，告诉Python不要处理反斜杠作为转义字符
    dlt_path = r'D:\DltCheck'
    app_name = 'DltViewerSDK\dlt-viewer.exe'  # Windows系统下的可执行文件
    # app_name = 'your_app'  # 如果是在Linux或macOS系统下，可能不需要文件扩展名

    # 获取当前工作目录
    current_dir = os.getcwd()
    # 使用glob模块查找所有的.txt文件
    dlt_files = glob.glob(os.path.join(current_dir, '*.dlt'))

    # 构建应用程序的完整路径
    app_path = os.path.join(current_dir, app_name)

    # 指定要打开的.dlt文件的路径
    # dlt_file_name = '123.dlt'  # 替换为你的.dlt文件名
    # dlt_file_path = os.path.join(dlt_path, dlt_file_name)



    try:
        # 使用subprocess.run()打开应用程序
        #subprocess.run([app_path], check=True)

        # 假设dlt-viewer.exe支持命令行参数打开文件
        #subprocess.Popen([app_path, dlt_file_path])

        #循环打开工作目录下的所有.dlt文件
        for dlt_file in dlt_files:
            dlt_file_path = os.path.join(current_dir, dlt_file)
            subprocess.Popen([app_path, dlt_file_path])
        main.main(sys.argv)
    except subprocess.CalledProcessError as e:
        print(f"无法启动应用程序: {e}")
    except FileNotFoundError:
        print(f"未找到应用程序: {app_path}")
    except Exception as e:
        print(f"启动应用程序时发生错误: {e}")

if __name__ == '__main__':
    open()
