import { createApp } from 'vue'
import App from './App.vue'
import ElementPlus from "element-plus"
import 'element-plus/dist/index.css'
import hljs from "highlight.js";
// 使用样式，有多种样式可选
import 'highlight.js/styles/github-dark.css';
// 拷贝包
import VueClipboard from 'vue-clipboard2'

const app = createApp(App)
    .use(ElementPlus)
    .use(VueClipboard)
    .mount('#app')


app.directive("highlight", function (el) {
    let blocks = el.querySelectorAll("pre code");
    blocks.forEach(block => {
        hljs.highlightBlock(block);
    });
});

// 增加组定义属性，用于在代码中预处理代码格式
app.prototype.$hljs = hljs;


