import { createApp } from 'vue'
import App from './App.vue'
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import { createRouter, createWebHistory } from 'vue-router'
// 导入路由识图
import UID from "./views/UID.vue"
import MD5 from "./views/MD5.vue"
import SHA256 from "./views/SHA256.vue"
import QRCode from "./views/QRCode.vue"
import IP from "./views/IP.vue"
import DNS from "./views/DNS.vue"
import Morse from "./views/Morse.vue"

// 路由配置
const routes = [
  { path: '/', component: UID },
  { path: '/md5', component: MD5 },
  { path: '/sha256', component: SHA256 },
  { path: '/qr_code', component: QRCode },
  { path: '/ip', component: IP },
  { path: '/dns', component: DNS },
  { path: '/morse', component: Morse },
]

// 创建路由实例
const router = createRouter({
  history: createWebHistory(),
  routes,
})

createApp(App)
.use(ElementPlus)
.use(router)
.mount('#app')
