# -*- coding: utf-8 -*-
# @File    : 最速下降法.py
# @Time    : 2021/4/14
# @Author  : laipinyan
from sympy import *
import numpy as np


def main():
    global init,D
    num=0
    init_new=init
    D = np.array(D)
    while 1:
        num=num+1
        print(f'__________________第{num}次迭代_____________________________________________________________________________')
        #算梯度
        for i in range(len(D)):
            new_x1 = init_new[0] + t * D[i][0]
            new_x2 = init_new[1] + t * D[i][1]
            f_new = f.subs([(x1, new_x1), (x2, new_x2)])  # 新函数
            grad_new = diff(f_new, t)  # 对t偏导
            t_val = nsolve(grad_new, t, 0)  # 求t
            print(f'令x^({num},{i})=x^({num-1})={init_new}^T，从x^({num},{i})出发沿着方向d^({num},{i+1})={D[i]}做一维搜索，即求解minf(x^({num},{i})+td^({num},{i+1}))\n'
                  f'∵x^({num},{i})+td^({num},{i+1})=({new_x1},{new_x2})\n'
                  f'∴令φ(λ)=f(x^({num},{i})+td^({num},{i+1}))={f_new}\n'
                  f'令φ´(λ)={grad_new}=0\n'
                  f'解得λ{i + 1}={t_val}')
            new_x1 = new_x1.subs(t, t_val)
            new_x2 = new_x2.subs(t, t_val)# 新点
            init_new = [new_x1, new_x2]
            print(f'∴x^({num},{i+1})=x^({num},{i})+td^({num},{i+1})={new_x1,new_x2}^T')
            print('______')
        n,m=D.shape
        r=np.linalg.matrix_rank(D.astype(np.float))
        if r<n:
            print(f'\n________________________________结果______________________________________________________\n'
                  f'两个搜索方向线性相关，迭代后x^({num},{i+1})=x^({num},{i})+td^({num},{i+1})={new_x1,new_x2}^T')
            break
        else:
            d = np.array([[new_x1 - init[0], new_x2 - init[1]]])
            D = np.concatenate((D, d), axis=0)
            new_x1 = init_new[0] + t * d[0][0]
            new_x2 = init_new[1] + t * d[0][1]
            f_new = f.subs([(x1, new_x1), (x2, new_x2)])  # 新函数
            grad_new = diff(f_new, t)  # 对t偏导
            t_val = nsolve(grad_new, t, 0)  # 求t
            print(
                f'令x^({num},{i + 1})=x^({num - 1})={init_new}^T，从x^({num},{i})出发沿着方向d^({num},{i + 2})=x({num},{i + 1})-({num},0)={d}做一维搜索，即求解minf(x^({num},{i})+td^({num},{i + 2}))\n'
                f'∵x^({num},{i + 1})+td^({num},{i + 1})=({new_x1},{new_x2})\n'
                f'∴令φ(λ)=f(x^({num},{i + 1})+td^({num},{i + 2}))={f_new}\n'
                f'令φ´(λ)={grad_new}=0\n'
                f'解得λ{i + 2}={t_val}')
            new_x1 = new_x1.subs(t, t_val)
            new_x2 = new_x2.subs(t, t_val)  # 新点
            init_new = [new_x1, new_x2]
            print(f'∴x^({num},{i + 2})=x^({num},{i})+td^({num},{i + 2})={new_x1, new_x2}^T')
            if np.linalg.norm(
                    np.array([float(init_new[0]) - float(init[0]), float(init_new[1]) - float(init[1])])) >= dx:
                D = D[1:]
                init = init_new
            else:
                print(f'\n________________________________结果______________________________________________________\n'
                      f'最终点位：x^({num},{i + 1})=x^({num},{i})+td^({num},{i + 1})={new_x1, new_x2}^T')
                break






if __name__ == '__main__':
    x1, x2, t = symbols('x1'), symbols('x2'), symbols('t')
    f = (x1+x2)**2+(x1-1)**2  # 设置初始函数
    init = [2, 1]  # 设置初始点
    D=[[1,0],[0,1]]  # 设置初始搜索方向
    dx = 0.01  # 设置迭代精度
    main()

