#----牛顿法求根-----#
import numpy as np
from sympy import *

def gradiant(FF,init,d,num):
    print(f"原始点x{num}={init}")
    new_x1 = init[0] + t * d[0]
    new_x2 = init[1] + t * d[0]
    f_new = FF.subs([(x1, new_x1), (x2, new_x2)])  # 新函数
    grad_new = diff(f_new, t)  # 对t偏导
    t_val = nsolve(grad_new, t, 0)  # 求t
    init_new = [new_x1.subs(t, t_val), new_x2.subs(t, t_val)]  # 新点
    f_value = FF.subs([(x1, init_new[0]), (x2, init_new[1])])  # 目标函数值
    print(f'令x^{num + 1}=x^{num}+λd^{num}，求解minφ(λ)\n'
          f'解得λ={t_val}\n'
          f'新点：{init_new}')
    return t_val,init_new,f_value


def main():
    global init
    A=np.empty([len(F),len(x)])
    f_val=[[]for i in range(len(F))]
    FF=0*x1
    num=0
    while 1: #采用残差来判断
        num=num+1
        print(f"___________________第{num}次迭代______________________________________")
        for i in range(len(F)):
            for j in range(len(x)):
                A[i][j]=diff(F[i],x[j]).subs([(x1, init[0]), (x2, init[1])])
            f_val[i]=F[i].subs([(x1, init[0]), (x2, init[1])])
            FF=FF+(F[i])**2
        A=np.array(A)
        f_val=np.array(f_val)
        r=np.linalg.matrix_rank(A)
        if r==len(x):
            d=-np.dot(np.dot(np.linalg.inv(np.dot(A.T,A)),A.T),f_val)
        elif r<len(x):
            d=-np.dot(A.T,f_val)
        t_val,init_new,f_value=gradiant(FF,init,d,num)
        if np.linalg.norm(np.dot(A.T,f_val).astype('float')) >= e:
            print(f'第{num}次迭代，原始点位为{init}，高斯牛顿方向为{d},目标点位：{init_new}，目标函数值：{f_value}')
            init=init_new
        else:
            print("_____________over__________________")
            print(f"最终点位x：{init_new}")  # 输出数值解
            print(f"最终f(x):{f_value}")  # 验证解的正确性
            print(f"最终迭代次数{num}")  # 输出迭代次数
            break

if __name__ == '__main__':
    # e = 10 ** (-9)  # 误差要求
    x1, x2= symbols('x1,x2')
    # x=[x1,x2]
    # f1=2*x1+2*x2-3
    # f2=x1-2*x2-1
    # f3=x1+4*x2-3
    # F=[f1,f2,f3]
    # init=[0,1]  ##定义初始点位
    t=symbols("t")  ##定义λ变量
    # main()
    FF=x1**2-2*x1+3*x2**2
    init=[2,-3]
    d=[4,1]
    num=0
    gradiant(FF, init, d, num)
