#----牛顿法求根-----#
import numpy as np
from sympy import *


def main():

    global init
    L=0
    while 1: #采用残差来判断
        g1 = diff(f, x1).subs([(x1, init[0]), (x2, init[1])])  # 对x偏导
        g2 = diff(f, x2).subs([(x1, init[0]), (x2, init[1])])  # 对y偏导
        g = np.array([float(g1), float(g2)]).T
        g11 = diff(diff(f, x1), x1).subs([(x1, init[0]), (x2, init[1])])
        g12 = diff(diff(f, x1), x2).subs([(x1, init[0]), (x2, init[1])])
        g21 = diff(diff(f, x2), x1).subs([(x1, init[0]), (x2, init[1])])
        g22 = diff(diff(f, x2), x2).subs([(x1, init[0]), (x2, init[1])])
        G = np.linalg.inv(np.array([[float(g11), float(g12)], [float(g21), float(g22)]]))
        print(g)
        if (np.linalg.norm(g)) > e:
            init_new = init - np.dot(G, g)
            L = L + 1  # 统计迭代次数
            f_value = f.subs([(x1, init_new[0]), (x2, init_new[1])])  # 目标函数值
            print(f'第{L}次迭代，原始点位为{init}，牛顿方向为{-np.dot(G, g)},目标点位：{init_new}，目标函数值：{f_value}')
            init=init_new
        else:
            print("_____________over__________________")
            print(f"最终点位x：{init}")  # 输出数值解
            print(f"最终f(x):{f_value}")  # 验证解的正确性
            print(f"最终迭代次数{L}")  # 输出迭代次数
            break

if __name__ == '__main__':
    e = 10 ** (-9)  # 误差要求
    L = 0  # 初始化迭代次数
    x1, x2 = symbols('x1'), symbols('x2')
    f = 2*x1**2-2*x1*x2+x2**4+x2  # 设置初始函数
    # f = x1**2+4*x2**2+x1*x2

    init = (-2,1)  # 设置初始点
    main()
