# -*- coding: utf-8 -*-
# @File    : 最速下降法.py
# @Time    : 2021/4/14
# @Author  : laipinyan
from sympy import *
import numpy as np


def main():
    global init
    for i in range(nub_iter):
        print(f'__________________第{i+1}次迭代_________________________________')
        #算梯度
        g1 = diff(f, x1).subs([(x1, init[0]),(x2,init[1])])  # 对x偏导
        g2 = diff(f, x2).subs([(x1, init[0]),(x2,init[1])])  # 对y偏导
        print(f'∵∇f(x)=({diff(f, x1)},{diff(f, x2)})^T\n'
              f'∴d^{i+1}=-∇f(x)=(-{g1},-{g2})^T\n'
              f'∴x^{i+1}+λd^{i+1}=({x1}-{g1}λ,{x2}-{g2}λ)^T')
        new_x1 = init[0] + t*(-g1)
        new_x2 = init[1] + t*(-g2)
        f_new = f.subs([(x1, new_x1), (x2, new_x2)])  # 新函数
        grad_new = diff(f_new, t)  # 对t偏导
        t_val = nsolve(grad_new, t,0)  # 求t
        init_new = (new_x1.subs(t, t_val), new_x2.subs(t, t_val))  # 新点
        f_value = f.subs([(x1, init_new[0]), (x2, init_new[1])])  # 目标函数值
        print(f'令φ(λ)=f(x^{i+1}+λd^{i+1})={f_new}\n'
              f'求解minφ(λ)\n'
              f'令φ´(λ)={grad_new}=0\n'
              f'解得λ{i+1}={t_val}\n'
              f'∴x^{i+2}=x^{i+1}++λ{i+1}d^{i+1}={init_new}\n'
              f'  f(x^{i+2})={f_value}')
        print(f"{i+1}次迭代总结：原始点位{init}，最速下降方向{np.array([-g1,-g2])},最优步长{t_val},目标点位{init_new},目标函数值{f_value}")
        init=init_new


if __name__ == '__main__':
    x1, x2, t = symbols('x1'), symbols('x2'), symbols('t')
    f = 2*x1**2+x2**2-4*x1 # 设置初始函数
    init = (0, 1)  # 设置初始点
    nub_iter = 2  # 设置迭代次数
    main()

