import { defineStore } from 'pinia'

export const useUserStore = defineStore('user', () => {
    const token = useCookie('token')
    const userInfo = useCookie('user-info')

    const $info = computed(() => userInfo.value ? userInfo.value : {})
    const $isSignIn = computed(() => !!token.value)

    function $signOut () {
        token.value = null
        userInfo.value = null
    }

    async function $updateUserInfo () {
        if (!token.value) return
        const { data } = await useRequest('/v1/user/user_info')
        userInfo.value = data.value.data
    }

    return { $info, $isSignIn, $signOut, $updateUserInfo }
})
