// https://nuxt.com/docs/api/configuration/nuxt-config
const sw = process.env.SW === 'true'
export default defineNuxtConfig({
    devtools: {
        enabled: false
    },
    modules: [
        '@vite-pwa/nuxt',
        '@nuxt/ui',
        '@nuxt/image',
        '@nuxtjs/mdc',
        '@nuxtjs/device',
        '@vueuse/nuxt',
        '@pinia/nuxt'
    ],
    ui: {
        icons: ['simple-icons']
    },
    app: {
        head: {
            meta: [
                {
                    name: 'viewport',
                    content: 'width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0'
                },
                {
                    charset: 'utf-8'
                }
            ]
        }
    },
    mdc: {
        headings: {
            anchorLinks: false
        },
        // components: {
        //     prose: false,
        //     map: {
        //         p: 'ProseP',
        //         h1: 'ProseH1',
        //         h2: 'ProseH2',
        //         h3: 'ProseH3',
        //         h4: 'ProseH4',
        //         h5: 'ProseH5',
        //         h6: 'ProseH6',
        //         ul: 'ProseUl',
        //         ol: 'ProseOl',
        //         li: 'ProseLi',
        //         blockquote: 'ProseBlockquote',
        //         hr: 'ProseHr',
        //         pre: 'ProsePre',
        //         code: 'ProseCode',
        //         table: 'ProseTable',
        //         thead: 'ProseThead',
        //         tbody: 'ProseTbody',
        //         tr: 'ProseTr',
        //         th: 'ProseTh',
        //         td: 'ProseTd',
        //         a: 'ProseA',
        //         img: 'ProseImg',
        //         em: 'ProseEm',
        //         strong: 'ProseStrong'
        //     }
        // }
    },
    pwa: !sw ? {} : {
        strategies: sw ? 'injectManifest' : 'generateSW',
        srcDir: sw ? 'service-worker' : undefined,
        filename: sw ? 'sw.ts' : undefined,
        registerType: 'autoUpdate',
        manifest: {
            name: 'GitBot',
            short_name: 'GitBot',
            theme_color: '#ffffff',
            icons: [
                {
                    src: 'pwa-192x192.png',
                    sizes: '192x192',
                    type: 'image/png',
                },
                {
                    src: 'pwa-512x512.png',
                    sizes: '512x512',
                    type: 'image/png',
                },
                {
                    src: 'pwa-512x512.png',
                    sizes: '512x512',
                    type: 'image/png',
                    purpose: 'any maskable',
                },
            ],
        },
        workbox: {
            globPatterns: ['**/*.{js,css,html,png,svg,ico}'],
        },
        injectManifest: {
            globPatterns: ['**/*.{js,css,html,png,svg,ico}'],
        },
        client: {
            installPrompt: true,
            // you don't need to include this: only for testing purposes
            // if enabling periodic sync for update use 1 hour or so (periodicSyncForUpdates: 3600)
            periodicSyncForUpdates: 20,
        },
        devOptions: {
            enabled: true,
            suppressWarnings: true,
            navigateFallback: '/',
            navigateFallbackAllowlist: [/^\/$/],
            type: 'module',
        },
    }
})