const BASE_URL = 'https://gpu-pod656e861afe3d944d6b3ce77e-7862.node.inscode.run'

const request = async (url, options = {}) => {
    const token = useCookie('token')
    const fullUrl = BASE_URL + url
    const config = {
        method: options.method || 'get',
        headers: {
            'Content-Type': 'application/json',
            'Authorization': token
        },
        onRequest({ request, options }) {
            // 设置请求头
        },
        onRequestError({ request, options, error }) {
            // 处理请求错误
            error && console.error(error)
        },
        onResponse({ request, response, options }) {

        },
        onResponseError({ request, response, options }) {
            // 处理响应错误
            console.log('[ResponseError]', request)
        }
    }
    if (options && options.headers) {
        Object.assign(config.headers, options.headers)
        delete options.headers
    }
    return useFetch(fullUrl, Object.assign(config, options));
}

export default request
