---

layout: default

title: PhotoSwipe Options

h1_title: Options

description: Complete list of PhotoSwipe options (including PhotoSwipeUI_Default options).

addjs: true

canonical_url: http://photoswipe.com/documentation/options.html

buildtool: true

markdownpage: true

---

选项以键值对的形式添加，并作为参数传递到 `PhotoSwipe` 构造函数，例如:

```javascript
var options = {
	index: 3,
	escKey: false,

	// ui option
	timeToIdle: 4000
};
var gallery = new PhotoSwipe( someElement, PhotoSwipeUI_Default, someItems, options);
gallery.init();

// Note that options object is cloned during the initialization.
// But you can access it via `gallery.options`.
// For example, to dynamically change `escKey`:
gallery.options.escKey = false;

// `options.escKey = false` will not work

```

## 核心

### `index`<code class="default"> 整数 </code><code class="default">0</code>

开始幻灯片索引。`0` 是第一张幻灯片。必须是整数，而不是字符串。

### `getThumbBoundsFn`<code class="default">函数</code><code class="default"> 未定义</code>

函数应该返回一个具有初始放大动画将从其开始（或缩小动画将结束）的坐标的对象。

对象应该包含三个属性:`x`（x 位置，相对于文档），`y`（y 位置，相对于文档），`w`（元素的宽度）。高度将根据大型图像的大小自动计算。例如，如果你返回 `{x:0,y:0,w:50}`，缩放动画将在页面的左上角开始。

函数有一个参数-`index` 的项目是打开或关闭。

在非模态模式下，模板相对于视口的位置应该从 `x` 和 `y` 中减去。有关更多信息，请参见 [the FAQ](faq.html#inline-gallery)。

计算缩略图位置的示例:

```javascript
getThumbBoundsFn: function(index) {

	// find thumbnail element
	var thumbnail = document.querySelectorAll('.my-gallery-thumbnails')[index];
	
	// get window scroll Y
	var pageYScroll = window.pageYOffset || document.documentElement.scrollTop; 
	// optionally get horizontal scroll

	// get position of element relative to viewport
	var rect = thumbnail.getBoundingClientRect(); 
	
	// w = width
	return {x:rect.left, y:rect.top + pageYScroll, w:rect.width};


	// Good guide on how to get element coordinates:
	// http://javascript.info/tutorial/coordinates
}
```

如果你的小缩略图的尺寸与大图片的尺寸不匹配，可以考虑启用缩放 + 渐变转换。你可以通过添加选项 `showHideOpacity:true`（尝试将其添加到 [above CodePen](http://codepen.io/dimsemenov/pen/ZYbPJM) 以测试其外观）来实现此目的。或者通过添加 `hideAnimationDuration:0, showAnimationDuration:0` 完全禁用转换。[常见问题解答中有关此的更多信息](faq.html#different-thumbnail-dimensions)。

如果要在动画制作过程中“隐藏”小缩略图，请使用 `opacity:0`，而不是 `visibility:hidden` 或 `display:none`。不要在动画开始时强行进行绘图和布局，以避免滞后。

### `showHideOpacity`<code class="default"> 布尔 </code><code class="default"> 假的</code>

如果设置为 `false`:背景 `opacity` 和图像 `scale` 将被动画处理（图像不透明度始终为 1）。如果设置为 `true`:根 PhotoSwipe 元素 `opacity` 和图像 `scale` 将被动画。

要仅启用 `opacity` 转换（不使用 `scale`），请不要定义 `getThumbBoundsFn` 选项。

### `showAnimationDuration`<code class="default"> 整数 </code><code class="default">333</code>

初始放大转换持续时间（以毫秒为单位）。设置为 `0` 可禁用。除了这个 JS 选项，你还需要在 PhotoSwipe CSS 文件中更改转换持续时间:

```css
.pswp--animate_opacity,
.pswp__bg,
.pswp__caption,
.pswp__top-bar,
.pswp--has_mouse .pswp__button--arrow--left,
.pswp--has_mouse .pswp__button--arrow--right{
	-webkit-transition: opacity 333ms cubic-bezier(.4,0,.22,1);
	transition: opacity 333ms cubic-bezier(.4,0,.22,1);
}
```

如果使用 Sass，只需在 [_main-settings.scss ](https://github.com/dimsemenov/PhotoSwipe/blob/master/src/css/_main-settings.scss) 中更改转换持续时间变量。

### `hideAnimationDuration`<code class="default"> 整数 </code><code class="default">333</code>

与前一个选项相同，仅用于关闭（缩小）转换。在 PhotoSwipe 被打开 `pswp--open` 类将被添加到根元素之后，你可以使用它来在 CSS 中应用不同的转换持续时间。

### `bgOpacity`<code class="default">number</code><code class="default">1</code>

背景（`。pswp__bg`）不透明度。应该是从 0 到 1 的数字，例如 `0.7`。这种样式是通过 JS 而不是 CSS 定义的，因为该值用于一些基于手势的转换。

### `spacing`<code class="default">number</code><code class="default">0.12</code>

幻灯片之间的间距比。例如，`0.12` 将呈现为 12% 的滑动视口宽度（四舍五入）。

### `allowPanToNext`<code class="default"> 布尔 </code><code class="default"> 为真</code>

当当前项目被放大时，允许滑动导航到下一个 / 上一个项目。在没有硬件触控支持的设备上，选项始终是 `false`。

### `maxSpreadZoom`<code class="default">number</code><code class="default">2</code>

执行扩展（缩放）手势时的最大缩放级别。`2` 表示图像可以从原始尺寸缩放 2 倍。在这里尽量避免使用过大的值，因为太大的图像可能会在移动设备（尤其是 iOS）上导致内存问题。

### `getDoubleTapZoom`<code class="default">函数</code>

函数应该返回缩放级别，在双击手势后，或者当用户单击缩放图标时，或者在图像本身上单击鼠标时，图像将被缩放到该级别。如果你返回 `1`，图像将被放大到其原始大小。

默认值:

```javascript
getDoubleTapZoom: function(isMouseClick, item) {

	// isMouseClick          - true if mouse, false if double-tap
	// item                  - slide object that is zoomed, usually current
	// item.initialZoomLevel - initial scale ratio of image
	// 						   e.g. if viewport is 700px and image is 1400px,
	// 						   		initialZoomLevel will be 0.5

	if(isMouseClick) {

		// is mouse click on image or zoom icon
		
		// zoom to original
		return 1;

		// e.g. for 1400px image:
		// 0.5 - zooms to 700px
		// 2   - zooms to 2800px
		
	} else {

		// is double-tap
		
		// zoom to original if initial zoom is less than 0.7x,
		// otherwise to 1.5x, to make sure that double-tap gesture always zooms image
		return item.initialZoomLevel < 0.7 ? 1 : 1.5;
	}
}
```

函数每次启动放大动画时都被调用。因此，可以根据不同图像的大小或屏幕 DPI 返回不同的值。

### `loop`<code class="default"> 布尔 </code><code class="default"> 为真</code>

使用滑动手势时循环幻灯片。如果设置为 `true`，你将能够从最后一张图像滑动到第一张图像。当幻灯片少于 3 张时，选项总是 `false`。

此选项与箭头导航无关。箭头循环将永久打开。你可以通过创建自定义 UI 来修改此行为。

### `pinchToClose`<code class="default"> 布尔 </code><code class="default"> 为真</code>

捏以关闭画廊的手势。随着用户的放大，图库的背景将逐渐淡出。当手势完成时，画廊将关闭。

### `closeOnScroll`<code class="default"> 布尔 </code><code class="default"> 为真</code>

在页面滚动中关闭图库。该选项仅适用于不支持硬件触控的设备。

### `closeOnVerticalDrag`<code class="default"> 布尔 </code><code class="default"> 为真</code>

当图像垂直拖动或未缩放时，关闭图库.当使用鼠标时，总是 `false`。
 

### `mouseUsed`<code class="default"> 布尔 </code><code class="default"> 假的</code>

选项允许你预先定义是否使用了鼠标。 PhotoSwipe 一些功能依赖于它，例如，只有在使用鼠标之后才会显示默认的 UI 左 / 右箭头。如果设置为 `false`， PhotoSwipe 将在自己使用鼠标时开始检测，当找到鼠标时触发 `mouseUsed` 事件。

### `escKey`<code class="default"> 布尔 </code><code class="default"> 为真</code>

`esc` 键盘键关闭 PhotoSwipe 。选项可以动态更改（`yourphotoswipeinstance.options.esckey=false；`）。

### `arrowKeys`<code class="default"> 布尔 </code><code class="default"> 为真</code>

键盘左或右方向键导航.选项可以动态更改（`yourphotoswipeInstance.options.arrowkeys=false；`）。

### `history`<code class="default"> 布尔 </code><code class="default"> 为真</code>

如果设置为 `false`，则禁用历史模块（关闭图库的后退按钮，每个幻灯片的唯一 URL）。你也可以将 `history.js` 模块从你的构建中排除。

### `galleryUID`<code class="default"> 整数 </code><code class="default">1</code>

画廊唯一的 ID。历史模块在形成 URL 时使用.例如，使用 UID1 的 Gallery 的第二张图片将具有 URL:`http://example.com/#&gid=1&pid=2`。

### <a name="galleryPIDs"></a>`galleryPIDs`<code class="default"> 布尔 </code><code class="default"> 假的</code>

为形成 URL 时使用的每个幻灯片对象启用自定义 ID。如果选项集设置为 `true`，则幻灯片对象必须具有 `pid`（图片标识符）属性，该属性可以是字符串或整数。例如:

```js
var slides = [
	{
		src: 'path/to/1.jpg',
		w:500,
		h:400,
		pid: 'image-one'
	},
	{
		src: 'path/to/2.jpg',
		w:300,
		h:700,
		pid: 'image-two'
	},

	... 
];
```

第二张幻灯片将有 URL`http://example.com/#&gid=1&pid=image-two`。

在 [the FAQ section](faq.html#custom-pid-in-url) 中阅读有关如何实现自定义 PID 的更多信息。

### `errorMsg`<code class="default"> 字符串</code>

图像未加载时的错误消息.`%url%` 将被图像的 URL 替换。

默认值:

```html
<div class="pswp__error-msg"><a href="%url%" target="_blank">The image</a> could not be loaded.</div>
```

### `preload`<code class="default"> 数组 </code><code class="default">[1,1]</code>

根据移动方向对附近的幻灯片进行延迟加载。应该是一个有两个整数的数组，第一个是在当前图像之前预加载的数项，第二个是在当前图像之后预加载的数项。例如，如果你将它设置为[1,3]，它将在当前之前加载 1 个图像，在当前之后加载 3 个图像。值不能小于 1。

### `mainClass`<code class="default"> 字符串 </code><code class="default"> 未定义</code>

带有类名称的字符串，它将被添加到 PhotoSwipe （`）的根元素中。pswp`）。可以包含由空间分隔的多个类。

### `getNumItemsFn`<code class="default">函数</code>

函数应该返回图库中的项目总数。默认情况下，它返回幻灯片数组的长度。不要把非常复杂的代码放在这里，函数是经常执行的。

### `focus`<code class="default"> 布尔 </code><code class="default"> 为真</code>

打开 PhotoSwipe 元素后将设置焦点。

### `isClickableElement`<code class="default">函数</code>

默认值:

```javascript
isClickableElement: function(el) {
	return el.tagName === 'A';
}
```

函数应检查元素是否可单击。如果是 – PhotoSwipe 将不会调用 `preventDefault` 并且 `click` 事件将通过。函数应该尽可能地轻，因为它在拖动启动和拖动释放上执行了多次。

### `modal`<code class="default"> 布尔 </code><code class="default"> 为真</code>

控制 PhotoSwipe 是否应该展开以占据整个视口。如果为假， PhotoSwipe 元素将占用模板的定位父元素的大小。查看 [the FAQ](faq.html#inline-gallery) 了解更多信息。

## 默认 UI 选项

`PhotoSwipeUI_Default`（`dist/ui/ PhotoSwipe -ui-default.js`）的选项以与核心选项相同的方式添加到相同的对象中。

```javascript
// Size of top & bottom bars in pixels,
// "bottom" parameter can be 'auto' (will calculate height of caption)
// option applies only when mouse is used, 
// or width of screen is more than 1200px
// 
// (Also refer to `parseVerticalMargin` event)
barsSize: {top:44, bottom:'auto'}, 

// Adds class pswp__ui--idle to pswp__ui element when mouse isn't moving for 4000ms
timeToIdle: 4000,

// Same as above, but this timer applies when mouse leaves the window
timeToIdleOutside: 1000,

// Delay until loading indicator is displayed
loadingIndicatorDelay: 1000,

// Function builds caption markup
addCaptionHTMLFn: function(item, captionEl, isFake) {
	// item      - slide object
	// captionEl - caption DOM element
	// isFake    - true when content is added to fake caption container
	// 			   (used to get size of next or previous caption)
	
	if(!item.title) {
		captionEl.children[0].innerHTML = '';
		return false;
	}
	captionEl.children[0].innerHTML = item.title;
	return true;
},

// Buttons/elements
closeEl:true,
captionEl: true,
fullscreenEl: true,
zoomEl: true,
shareEl: true,
counterEl: true,
arrowEl: true,
preloaderEl: true,

// Tap on sliding area should close gallery
tapToClose: false,

// Tap should toggle visibility of controls
tapToToggleControls: true,

// Mouse click on image should close the gallery,
// only when image is smaller than size of the viewport
clickToCloseNonZoomable: true,

// Element classes click on which should close the PhotoSwipe.
// In HTML markup, class should always start with "pswp__", e.g.: "pswp__item", "pswp__caption".
// 
// "pswp__ui--over-close" class will be added to root element of UI when mouse is over one of these elements
// By default it's used to highlight the close button.
closeElClasses: ['item', 'caption', 'zoom-wrap', 'ui', 'top-bar'], 

// Separator for "1 of X" counter
indexIndicatorSep: ' / ',


{% raw %}
// Share buttons
// 
// Available variables for URL:
// {{url}}             - url to current page
// {{text}}            - title
// {{image_url}}       - encoded image url
// {{raw_image_url}}   - raw image url
shareButtons: [
	{id:'facebook', label:'Share on Facebook', url:'https://www.facebook.com/sharer/sharer.php?u={{url}}'},
	{id:'twitter', label:'Tweet', url:'https://twitter.com/intent/tweet?text={{text}}&url={{url}}'},
	{id:'pinterest', label:'Pin it', url:'http://www.pinterest.com/pin/create/button/?url={{url}}&media={{image_url}}&description={{text}}'},
	{id:'download', label:'Download image', url:'{{raw_image_url}}', download:true}
],
{% endraw %}

// Next 3 functions return data for share links
// 
// functions are triggered after click on button that opens share modal,
// which means that data should be about current (active) slide
getImageURLForShare: function( shareButtonData ) {
	// `shareButtonData` - object from shareButtons array
	// 
	// `pswp` is the gallery instance object,
	// you should define it by yourself
	// 
	return pswp.currItem.src || '';
},
getPageURLForShare: function( shareButtonData ) {
	return window.location.href;
},
getTextForShare: function( shareButtonData ) {
	return pswp.currItem.title || '';
},

// Parse output of share links
parseShareButtonOut: function(shareButtonData, shareButtonOut) {
	// `shareButtonData` - object from shareButtons array
	// `shareButtonOut` - raw string of share link element
	return shareButtonOut;
}
```

知道如何改进这个页面吗？找到了一个错别字？[建议编辑一下！](https://github.com/dimsemenov/PhotoSwipe/blob/master/website/documentation/responsive-images.md)

<iframe src="http://ghbtns.com/github-btn.html?user=dimsemenov&amp;repo=photoswipe&amp;type=watch&amp;count=true&amp;size=large" allowtransparency="true" frameborder="0" scrolling="0" width="155" height="30" style=""></iframe>

