---

layout: default

title: PhotoSwipe FAQ

h1_title: FAQ

description: Frequently asked questions and known issues about PhotoSwipe image gallery.

addjs: true

canonical_url: http://photoswipe.com/documentation/faq.html

buildtool: true

markdownpage: true

---

## 执行情况

### <a name="image-size"></a> 我无法预先定义图像大小，该怎么办？

使用另一个图库脚本（[1](http://dimsemenov.com/plugins/magnific-popup/)，[2](http://dimsemenov.com/plugins/royal-slider/gallery/)），或找到一种方法:

- 只需下载一小部分图像（[PHP version](http://stackoverflow.com/questions/4635936/super-fast-getimagesize-in-php)，[Ruby](https://github.com/sdsykes/fastimage)，[Node.js](http://stackoverflow.com/a/20111234/331460)），就可以读取图像的大小。
- 你可以直接将图像的大小存储在其文件名中，并在 PhotoSwipe 初始化期间（API 部分中的“gettingdata”事件）在前端对其进行解析。
- 大多数 CMS 将图像的大小存储在数据库中，并具有检索图像的 API。
- 大多数 Web API（Facebook、500px、Instagram、Flickr、Twitter、YouTube、Vimeo 等）都会返回一定大小的图片。

尺寸用于逐步加载、拉伸占位符、初始放大转换、平移、缩放、字幕定位。在 GitHub[issue #741](https://github.com/dimsemenov/PhotoSwipe/issues/741) 中进行讨论。

### <a name="different-thumbnail-dimensions"></a> 我的缩略图是正方形的，但是大的图像有不同的尺寸，那么打开 / 关闭过渡怎么办？

1. 如果缩略图长宽比与大图像不匹配，请不要为幻灯片对象定义 `msrc` 属性并启用不透明度转换选项（“showhideopacity:true，getthumbboundsfn:false”）。
2. 如果缩略图图像文件的长宽比匹配大图像，但缩略图区域是通过 CSS 裁剪的，只需添加 `showHideOpacity:true` 并确保 `getThumbBoundsFn` 选项返回考虑裁剪区域的坐标。

我强烈建议显示与大图像长宽比匹配的缩略图，或者通过 CSS（2）裁剪可见区域。

我将试着解释为什么这一点还没有实现。制作扩展区域动画有两种方法:

1. Animate`clip` 属性。但每次 [it forces Paint](http://csstriggers.com/#clip)，这使得动画生涩。
2. 用两个 div 展开的图像进行包装，这两个 div 具有 `overflow:hidden`，并在动画期间通过 `transform:translate` 重新定位它们，这样它们就会在正确的部分剪辑它。这种方法不强制绘制或布局，但需要在每个幻灯片的标记中添加两个元素。测试原型表明，它只能在高端移动设备（如 Nexus5 和 Chrome ）上流畅地工作。也许有一天我会实现它。

### <a name="scroll-in-caption"></a> 我的字幕很大，我可以添加滚动吗？

参考 [issue #657](https://github.com/dimsemenov/PhotoSwipe/issues/657)。

### <a name="inline-gallery"></a> 如何实现内联图库显示

请注意，这是一个实验性的功能，目前它不允许在移动设备上在图库上垂直滚动页面（在 Touch Events 上它调用 `prevetDefault()`）。如果发现问题，请报告。要实现与文档其余部分一起运行的嵌入式图库，请遵循以下步骤:

1. 将 `.pswp` 模板放入定位的父元素中。
2. 设置 `modal: false, closeOnScroll: false` 选项。
3. 修改 `getThumbBoundsFn`（如果你正在使用它）以减去模板父级的边界 rect。
4. 构造 PhotoSwipe 。
5. 监听 `updateScrollOffset` 事件，并将模板的边界矩形添加到偏移量。
6. `init()`the PhotoSwipe 。

[**CodePen→上的实时示例 **](http://codepen.io/dimsemenov/pen/JogxWM)

```html
<div style="position: relative;" class="parent">
    <div id="gallery" class="pswp"> ... </div>
</div>
```

```javascript
var items = [...];
var template = document.getElementById("gallery"); // .pswp
var options = {
    ...,
    modal: false,
    closeOnScroll: false,
    getThumbBoundsFn: function(index) {
        // rect was the original bounds
        var rect = {x: ..., y: ..., w: ...},

        var templateBounds = template.parentElement.getBoundingClientRect();
        rect.x -= templateBounds.left;
        rect.y -= templateBounds.top;

        return rect;
    }
};
var photoSwipe = new PhotoSwipe(template, PhotoSwipeUI_Default, items, options);
photoSwipe.listen('updateScrollOffset', function(_offset) {
    var r = template.getBoundingClientRect();
    _offset.x += r.left;
    _offset.y += r.top;
});
photoSwipe.init();
```

### <a name="custom-pid-in-url"></a> 如何在 URL 中使用自定义标识符而不是索引

要使 URL 到单个图像看起来像这样:

```
http://example.com/#&gid=1&pid=custom-first-id
http://example.com/#&gid=1&pid=custom-second-id
```

而不是:

```
http://example.com/#&gid=1&pid=1
http://example.com/#&gid=1&pid=2
```

...启用选项 `history:true, galleryPIDs:true` 并将 `pid`（唯一图片标识符）属性添加到幻灯片对象（`pid’可以是整数或字符串），例如:

```js
var slides = [
    {
        src: 'path/to/1.jpg',
        w:500,
        h:400,
        pid: 'custom-first-id'
    },
    {
        src: 'path/to/2.jpg',
        w:300,
        h:700,
        pid: 'custom-second-id'
    },
    ... 
];
```

- 请注意， PhotoSwipe 不执行任何代码，直到你初始化并打开它。这就是为什么在初始页面加载时需要自己解析 URL 的原因。文档的 [Getting Started](http://photoswipe.com/documentation/getting-started.html#dom-to-slide-objects) 部分中的默认代码包括此功能（如果需要进行一些修改，请检查 `photoswipeParseHash`函数）。
- 选项 `galleryPIDs` 自 PhotoSwipe v4.0.8（[选项描述](options.html#galleryPIDs)）起可用。

## 虫子

### <a name="gif-freeze-ios"></a>GIF 图像有时会在 iOS8 上冻结

iOS Safari 有一个 bug，它会冻结移动到窗口之外（或带有 `overflow:hidden` 的元素之外）的 GIF 图像。我的建议是完全避免在 PhotoSwipe 中使用动画 GIF，因为它们会降低任何移动浏览器中的动画性能。但如果你确实需要使用它，请参考 [this hack](https://github.com/dimsemenov/PhotoSwipe/issues/662#issuecomment-66420874)。

### <a name="mobile-crash"></a> 打开带有大型图片的图库时，移动浏览器会崩溃

大多数情况下，它可以发生在内存限制较低的移动设备上 –iOS Safari，这是旧 Android（KitKat 之前）的默认浏览器。最常见的崩溃原因是太大的图像（通常大于 2000x1500px）。 PhotoSwipe 在图像上应用硬件加速，这比页面上的常规图像消耗更多的内存，因此当你超出限制时，浏览器开始滞后甚至崩溃。

所以 [提供响应图像](responsive-images.html)，或者至少不提供巨大的图像。理想情况下，对于一部平均 900x600 的手机，你应该提供 1200 像素宽的图像。请注意，如果在 iOS 模拟器中一切顺利，这并不意味着崩溃不会发生在真正的设备上。

在更罕见的情况下，如果在页面的某些过程中打开 PhotoSwipe （这可以是初始的页面加载 / 呈现，或者是页面上的某些复杂动画），则可能会发生崩溃，请尝试延迟 PhotoSwipe 初始化，直到页面呈现（在 document.ready.ready 之后的 18-300ms），特别是如果你正在显示大型图像。

Upd.:在 [v4.1.0](https://github.com/dimsemenov/PhotoSwipe/releases/tag/v4.1.0) 中，这是部分固定的。

## 杂项

### <a name="keep-updated"></a> 变更日志在哪里，如何获得更新通知？

每次 PhotoSwipe 获得更新时-[GitHub releases](https://github.com/dimsemenov/PhotoSwipe/releases) 页面都会更新详细信息。发布页面有一个 [Atom feed](https://github.com/dimsemenov/PhotoSwipe/releases.atom)，你可以在提要更新 [using IFTTT](https://ifttt.com/recipes/230902-photoswipe-update-notification) 时设置电子邮件通知。

还有，你可以加入我的 [电子邮件通讯](http://dimsemenov.com/subscribe.html?i=pswp)（一年发送 3-4 次），关注 [@PhotoSwipe on Twitter](http://twitter.com/photoswipe)，和 star/watch[PhotoSwipe on GitHub](https://github.com/dimsemenov/PhotoSwipe/)。

### <a name="wordpress-release"></a>WordPress 插件何时发布？

Plugin 正在开发中，将于 2015 年发布。以获得通知 [订阅我的时事通讯](http://dimsemenov.com/subscribe.html?i=pswp-wp)。

### <a name="can-i-use-in-theme"></a> 我想在 wordpress/magento/joomla...模板中使用 PhotoSwipe ，可以吗？

是的，你可以使用 PhotoSwipe 中的免费或商业主题，没有任何限制。如果可以，请在主题描述或 / 和管理区域中留下信用额度（链接到 PhotoSwipe 主页）。

<div style="margin-top:30px;"><p> 知道如何改进这个页面吗？发现了语法错误？<a href="https://github.com/dimsemenov/PhotoSwipe/blob/master/website/documentation/responsive-images.md"> 请编辑！</a></p></div>

<iframe src="http://ghbtns.com/github-btn.html?user=dimsemenov&amp;repo=photoswipe&amp;type=watch&amp;count=true&amp;size=large" allowtransparency="true" frameborder="0" scrolling="0" width="155" height="30" style=""></iframe>

<style type="text/css">
body {
    overflow-y:scroll;
}
h3 {
    cursor: pointer;
    font-weight: normal;
    -webkit-user-select:none;
    -moz-user-select:none;
    user-select:none;
    color: #3169B3;
    padding-left: 18px;
    position: relative;
}
h3:hover {
    color: #C00;
}
h3:before {
    content:'▼';
    font-size: 12px;
    position: absolute;
    left: 0;
    top: 2px;
}
h3.tab-closed:before {
    content: '►';
}
</style>

<script>
(function() {

    // tabs

    if(!document.addEventListener) {
        return;
    }

    var els = document.getElementsByClassName('row--docs')[0].children,
        el;

    var isContentEl = function(el) {
            if(!el) {
                return;
            }
            if( (/(P|UL|OL)/i).test(el.tagName) || el.className === 'highlight' ) {
                return true;
            }
            return;
        },
        toggleTab = function(el) {
            var dStyle = el.classList.contains('tab-closed') ? 'block' : 'none';
            el.classList.toggle('tab-closed');

            var s = el.nextElementSibling;
            while( isContentEl(s) ) {
                s.style.display = dStyle;
                s = s.nextElementSibling;
            }
        };

    for(var i = 0; i < els.length; i++) {
        el = els[i];

        if(el.tagName === 'H3') {

            if(window.location.hash !== '#' + el.firstElementChild.name) {
                toggleTab(el);
            }
            
            el.onclick = function() {
                toggleTab(this);
            };
        }
    }

})();
</script>

