---

layout: default

title: Custom HTML Content in PhotoSwipe Slides 

h1_title: Custom HTML Content in Slides

description: How to add custom HTML in PhotoSwipe slides, like ads or list of related galleries.

addjs: true

canonical_url: http://photoswipe.com/documentation/custom-html-in-slides.html

buildtool: true

markdownpage: true

---

要使 PhotoSwipe 在幻灯片中显示 HTML 内容，你需要在幻灯片对象中定义 `html` 属性。它应该包含 HTML 字符串或 DOM 元素对象。

```javascript

var items = [
	// slide 1 with HTML
	{
		html: '<div><h1>Any HTML <a href="http://example.com">content</a></h1></div>'
	},

	// slide 2 with image
	{
		src: 'path/to/image.jpg',
		w:600,
		h:200
	}
];


// initialise as usual
var gallery = new PhotoSwipe( pswpElement, PhotoSwipeUI_Default, items, options);

// You don't necessarily need to have "html" property in slide object initially.
// You may create it dynamically in gettingData event:
/*
	gallery.listen('gettingData', function(index, item) {
		if(index === 3) {
			item.html = '<div>Dynamically generated HTML ' + Math.random() + '</div>';
		}

	});
*/

// Note that init() method is called after gettingData event is bound
gallery.init();
```

其他重要注意事项:

- 为了避免与第三方模块发生冲突，具有 `html` 属性的幻灯片不应具有 `src` 属性。
- PhotoSwipe 是为图像而设计的，而不是作为文本内容的滚动轮。使用“自定义 HTML”功能作为补充，例如，对于带有相关图库的幻灯片、介绍性幻灯片或图像之间的广告。
- 强烈不建议使用这种方法添加视频或音频元素（包括 YouTube、Vimeo 等 iframes）。在许多移动浏览器中，HTML5 视频阻止了在其上的触摸事件（用户将无法滑动它）。如果你确实需要在 PhotoSwipe 中有视频，你可以将其添加为当用户点击当前幻灯片时出现的模态，你可以在 DOM 中动态地创建模态，并在 `.pswp__scroll-wrap` 元素之后追加它。
- 如果你启用了初始的放大 / 缩小转换， PhotoSwipe 将自动禁用它，如果当前幻灯片有 `html`，将使用简单的渐变转换。
- 默认情况下， PhotoSwipe 只允许单击链接（`<a>`）及其子元素上的事件。要更改此行为，请查看 `isClickableElement` 选项或 `preventDragEvent` 事件。
- 目前还不支持缩放 HTML 幻灯片。

示例:

<div class="codepen-embed">
	<p data-height="600" data-theme-id="10447" data-slug-hash="MYexrm" data-default-tab="result" data-user="dimsemenov" class='codepen'>
		<a href="http://codepen.io/dimsemenov/pen/MYexrm/" target="_blank"><strong>View example on CodePen &rarr;</strong></a>
	</p>
</div>

提示:你可以从 CodePen 下载示例，以便在本地使用它（“在 CodePen 上编辑 `->`Share`->`Export .zip`）。

知道如何改进这个页面吗？[建议编辑一下！](https://github.com/dimsemenov/PhotoSwipe/blob/master/website/documentation/custom-html-in-slides.md)

