---

layout: default

title: PhotoSwipe API

h1_title: API

description: Public methods, properties and events of PhotoSwipe JavaScript image gallery.

addjs: true

canonical_url: http://photoswipe.com/documentation/api.html

buildtool: true

markdownpage: true

---

此页面上列出的所有方法和属性都是公共的。如果你想查看 API 可以做什么的示例，请在 [source of default PhotoSwipe UI](https://github.com/dimsemenov/PhotoSwipe/blob/master/src/js/ui/photoswipe-ui-default.js) 中查看。

你可以在初始化期间获得 PhotoSwipe 实例对象，例如:

```javascript
var photoswipeInstance = new PhotoSwipe( /* ... */ );
```

## 方法

```javascript
var pswp = new PhotoSwipe( /* ... */ );

// Initialize and open gallery
// (you can bind events before this method)
pswp.init();

// Go to slide by index
// @param {int} `index`
pswp.goTo(index);

// Go to the next slide
pswp.next();

// Go to the previous slide
pswp.prev();

// Update gallery size
// @param  {boolean} `force` If you set it to `true`, 
// 							size of the gallery will be updated 
// 							even if viewport size hasn't changed.
pswp.updateSize(force);

// Close gallery
pswp.close();

// Destroy gallery,
// automatically called after close() 
pswp.destroy()

// Zoom current slide to (optionally with animation)
// @param  {number}   `destZoomLevel` Destination scale number. 1 - original.  
// 								     pswp.currItem.fitRatio - image will fit into viewport.
// @param  {object}   `centerPoint`   Object of x and y coordinates, relative to viewport.
// @param  {int}      `speed`         Animation duration. Can be 0.
// @param  {function} `easingFn`      Easing function (optional). Set to false to use default easing.
// @param  {function} `updateFn`      Function will be called on each update frame. (optional)
//
// Example below will 2x zoom to center of slide:
// pswp.zoomTo(2, {x:pswp.viewportSize.x/2,y:pswp.viewportSize.y/2}, 2000, false, function(now) {
// 		
// });
pswp.zoomTo(destZoomLevel, centerPoint, speed, easingFn, updateFn);

// Apply zoom and pan to the current slide
// 
// @param   {number} `zoomLevel`
// @param   {int}    `panX`
// @param   {int}    `panY`
// 
// For example: `pswp.applyZoomPan(1, 0, 0)`
// will zoom current image to the original size
// and will place it on top left corner
// 
// 
pswp.applyZoomPan(zoomLevel, panX, panY);
```

## 属性

```javascript

// current slide object
pswp.currItem

// items array (slides, images)
pswp.items

// size of sliding viewport
pswp.viewportSize

// object holds all functions from framework
// framework-bridge.js
pswp.framework

// UI object (e.g. PhotoSwipeUI_Default instance)
pswp.ui

// background element (pswp__bg)
pswp.bg

// container element (pswp__container)
pswp.container

// options
pswp.options



// Even though methods below aren't technically properties, we list them here:

// current item index (int)
pswp.getCurrentIndex();

// total number of items
pswp.options.getNumItemsFn()

// current zoom level (number)
pswp.getZoomLevel();

// one (or more) pointer is used
pswp.isDragging();

// two (or more) pointers are used
pswp.isZooming();

// `true` when transition between is running (after swipe)
pswp.isMainScrollAnimating();
```

## 事件

PhotoSwipe 使用非常简单的事件 / 消息传递系统。它有两个方法 `shout`（触发器事件）和 `listen`（处理事件）。目前还没有解除绑定 Listener 的方法，但是当 PhotoSwipe 关闭时，所有这些方法都将被清除。

```javascript
var pswp = new PhotoSwipe(/* ... */);

// Listen for "helloWorld" event
pswp.listen('helloWorld', function(name) {
	alert('Name is: ' + name);
});

// Trigger "helloWorld" event
pswp.shout('helloWorld', 'John' /* you may pass more arguments */);
```

可用活动:

```javascript

// Before slides change
// (before the content is changed, but after navigation)
// Update UI here (like "1 of X" indicator)
pswp.listen('beforeChange', function() { });

// After slides change
// (after content changed)
pswp.listen('afterChange', function() { });

// Image loaded
pswp.listen('imageLoadComplete', function(index, item) { 
	// index - index of a slide that was loaded
	// item - slide object
});

// Viewport size changed
pswp.listen('resize', function() { });

// Triggers when PhotoSwipe "reads" slide object data,
// which happens before content is set, or before lazy-loading is initiated.
// Use it to dynamically change properties
pswp.listen('gettingData', function(index, item) {
	// index - index of a slide that was loaded
	// item - slide object

	// e.g. change path to the image based on `something`
	if( something ) {
		item.src = item.something;
	} else {
		item.src = item.somethingElse;
	}
});

// Mouse was used (triggers only once)
pswp.listen('mouseUsed', function() { });


// Opening zoom in animation starting
pswp.listen('initialZoomIn', function() { });

// Opening zoom in animation finished
pswp.listen('initialZoomInEnd', function() { });

// Closing zoom out animation started
pswp.listen('initialZoomOut', function() { });

// Closing zoom out animation finished
pswp.listen('initialZoomOutEnd', function() { });


// Allows overriding vertical margin for individual items
pswp.listen('parseVerticalMargin', function(item) { 
	// For example:
	var gap = item.vGap;

	gap.top = 50; // There will be 50px gap from top of viewport
	gap.bottom = 100; // and 100px gap from the bottom
})

// Gallery starts closing
pswp.listen('close', function() { });

// Gallery unbinds events
// (triggers before closing animation)
pswp.listen('unbindEvents', function() { });

// After gallery is closed and closing animation finished.
// Clean up your stuff here.
pswp.listen('destroy', function() { });

// Called when the page scrolls.
// The callback is passed an offset with properties {x: number, y: number}.
//
// PhotoSwipe uses the offset to determine the top-left of the template,
// which by default is the top-left of the viewport. When using modal: false,
// you should listen to this event (before calling .init()) and modify the offset
// with the template's getBoundingClientRect().
//
// Look at the "Implementing inline gallery display" FAQ section for more info.
pswp.listen('updateScrollOffset', function(_offset) {
    var r = gallery.template.getBoundingClientRect();
    _offset.x += r.left;
    _offset.y += r.top;
});

// PhotoSwipe has a special event called pswpTap.
// It's dispatched using default JavaScript event model.
// So you can, for example, call stopPropagation on it.
// pswp.framework.bind - is a shorthand for addEventListener
pswp.framework.bind( pswp.scrollWrap /* bind on any element of gallery */, 'pswpTap', function(e) {
    console.log('tap', e, e.detail);
    // e.detail.origEvent  // original event that finished tap (e.g. mouseup or touchend)
    // e.detail.target // e.target of original event
    // e.detail.releasePoint // object with x/y coordinates of tap
    // e.detail.pointerType // mouse, touch, or pen
});

// Allow to call preventDefault on down and up events
pswp.listen('preventDragEvent', function(e, isDown, preventObj) {
	// e - original event
	// isDown - true = drag start, false = drag release

	// Line below will force e.preventDefault() on:
	// touchstart/mousedown/pointerdown events
	// as well as on:
	// touchend/mouseup/pointerup events
	preventObj.prevent = true;
});



// Default UI events
// -------------------------

// Share link clicked
pswp.listen('shareLinkClick', function(e, target) { 
	// e - original click event
	// target - link that was clicked

	// If `target` has `href` attribute and 
	// does not have `download` attribute - 
	// share modal window will popup
});


```

## 动态添加幻灯片

要在 PhotoSwipe 打开后添加、编辑或删除幻灯片，只需修改 `items` 数组。例如，你可以 push 将新的对象滑动到 `items` 数组中:

```javascript
pswp.items.push({
    src: "path/to/image.jpg", 
    w:1200,
    h:500 
});
```

如果你更改了当前、下一个或上一个幻灯片（你应该尽量避免）–，你需要调用将更新其内容的方法:

```javascript
// sets a flag that slides should be updated
pswp.invalidateCurrItems();
// updates the content of slides
pswp.updateSize(true);
```

否则，你不需要做任何其他事情。如果你想要更新默认 UI 的某些部分（例如，“1of X”计数器），也许可以调用 `pswp.ui.update()`。另请注意:

- 你不能重新分配整个数组，你只能修改它（例如，使用 `splice` 删除元素）。
- 如果要删除当前的幻灯片 –，请先调用 `goTo` 方法。
- 至少要有一张幻灯片。
- 此技术用于 [提供响应图像](responsive-images.html)。

缺少一些方法或属性？发现了语法错误？知道如何改进这个页面吗？[请建议编辑！](https://github.com/dimsemenov/PhotoSwipe/blob/master/website/documentation/api.md)

