---

layout: default

title: SEO Friendly JavaScript Image Gallery Markup

h1_title: Image Gallery SEO

description: Ideal HTML markup for JavaScript image gallery (lightbox type).

addjs: true

canonical_url: http://photoswipe.com/documentation/seo.html

buildtool: true

markdownpage: true

---

PhotoSwipe 不强制任何 HTML 标记，你可以完全控制。最简单的标记是链接到大图片的缩略图列表，最简单的例子:

```html
<a href="large-image.jpg">
    <img src="small-image.jpg" alt="Image description" />
</a>
...
```

如果你的长标题不适合 `alt`，或者它只包含 HTML 标记，则可以使用 `<figure>` 和 `<figcaption>`:

```html
<figure>
	<a href="large-image.jpg">
	    <img src="small-image.jpg" alt="Image description" />
	</a>
	<figcaption>Long image description</figcaption>
</figure>
...
```

你可以进一步使用 [ImageGallery 的 schema.org 标记](http://schema.org/ImageGallery) 和 [ImageObject](http://schema.org/ImageObject)，它应该是这样的:

```html
<div itemscope itemtype="http://schema.org/ImageGallery">

	<figure itemprop="associatedMedia" itemscope itemtype="http://schema.org/ImageObject">
		<a href="large-image.jpg" itemprop="contentUrl">
		    <img src="small-image.jpg" itemprop="thumbnail" alt="Image description" />
		</a>

		<!-- optionally use this method to store image dimensions for PhotoSwipe -->
		<meta itemprop="width" content="300">
		<meta itemprop="height" content="600">

		<figcaption itemprop="caption description">
			Long image description

			<!-- optionally define copyright -->
			<span itemprop="copyrightHolder">Photo: AP</span>
		</figcaption>
	</figure>

	<figure itemprop="associatedMedia" itemscope itemtype="http://schema.org/ImageObject">
		<a href="large-image.jpg" itemprop="contentUrl">
		    <img src="small-image.jpg" itemprop="thumbnail" alt="Image description" />
		</a>
		<figcaption itemprop="caption description">Long image description</figcaption>
	</figure>

	...

</div>
```

如果你不想在页面上看到缩略图，例如，你在图库中有 50 张图片，你只显示前 3 张缩略图 + 链接“查看所有图片（50）”，你肯定应该使用 [schema.org 标记](http://schema.org/ImageGallery)，并且在 DOM 中应该有所有 50 个链接（链接元素的内容中包含文本，而不是缩略图）（你可以用 `display:none` 隐藏它们）。示例:

```html
<div itemscope itemtype="http://schema.org/ImageGallery">

	<figure itemprop="associatedMedia" itemscope itemtype="http://schema.org/ImageObject">
		<a href="large-image-1.jpg" itemprop="contentUrl">
		    <figcaption itemprop="caption description">Long image description 1</figcaption>
		</a>
	</figure>

	<figure itemprop="associatedMedia" itemscope itemtype="http://schema.org/ImageObject">
		<a href="large-image-2.jpg" itemprop="contentUrl">
		    <figcaption itemprop="caption description">Long image description 2</figcaption>
		</a>
	</figure>

	...

</div>
```

在上述所有情况下，`large-image.jpg` 都将被完美地编入索引。即使你用 `display:none` 隐藏 caption 元素，它也会被抓取，只需保持文本的相关性，非垃圾邮件 –不要用关键字填充它。

### 补充建议

- 保持 `alt` 属性的简短和描述性。为 caption 元素保留较长的描述。
- [谷歌图片发布指南](https://support.google.com/webmasters/answer/114016).
- 使用 [Google](https://developers.google.com/webmasters/structured-data/testing-tool/) 或 [Yandex](https://webmaster.yandex.com/microtest.xml) 结构化数据测试工具来验证你的 schema.org 标记。
- 高分辨率的图像排名更好，通常 1680px 在更宽的一面是绰绰有余的。
- 在初始页面加载时可见的图片说明将总是比隐藏的排名更好。设法使缩略图和标题在页面上保持可见的图库布局的一个很好的例子是 [新的卫报画廊页面](http://www.theguardian.com/science/gallery/2015/mar/13/satellites-as-youve-never-seen-them-before-in-pictures)。
- 优化图像大小和格式:
	- [导游:Ilya Grigorik ](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/image-optimization).
	- 工具:对于 Mac 有 [ImageOptim](https://imageoptim.com/)，对于 Windows–[FileOptimizer](http://nikkhokkho.sourceforge.net/static.php?page=FileOptimizer) 或 [JPEGmini](http://www.jpegmini.com/windows)（精简版）。此外，还有很多服务器端 / 命令行工具，比如 [ImageMagick](http://www.imagemagick.org/) 或 [jpegtran](http://jpegclub.org/jpegtran/)。
	- 如果你为高 DPI（例如 Retina）屏幕提供不同的图像，请将它们的 JPEG 质量降低到 20-40%，以节省文件大小，[这方面的好文章](http://www.netvlies.nl/blog/design-interactie/retina-revolution)。
- 如果你有指向图像或 / 和 valid schema.org 标记的链接，则不需要创建图像站点地图，但是它可以帮助你 [track how well they are indexed](http://webmasters.stackexchange.com/a/5151)。
- 对于缩略图，可以使用 `srcset` 或 `<picture>`。
- 要小心画廊页面上的缩略图数量，缓慢的页面加载速度可能会损害排名。
- 搜索引擎可以很好地索引到图像文件的直接链接，特别是使用 schema.org 标记。但是，当每一张图片都有一个描述性的和唯一的标题、描述和注释时，为每一张图片设置一个单独的 HTML 页面会更好。

知道如何改进这个页面吗？[请建议编辑！](https://github.com/dimsemenov/PhotoSwipe/blob/master/website/documentation/seo.md)

