---

layout: default

title: PhotoSwipe Performance Tips

h1_title: Performance Tips

description: Suggestions on how to make gallery faster.

addjs: true

canonical_url: http://photoswipe.com/documentations/performance-tips.html

buildtool: true

markdownpage: true

---

## 动画

- 动画的表现极大地取决于图像的大小。较小的图像 –更平滑的动画。因此，不要偷懒和 [提供响应图像](responsive-images.html)，或者至少不要为手机提供大于 1200x1200 的图像。
- 不要在动画期间做任何可能导致油漆或布局的事情。不要在 DOM 中添加新元素。不要更改 `display` 或 `visibility`。别呼吸。你只能更改 `transform` 和 `opacity`。在动画结束后延迟所有更改 –use 事件:`beforeChange`（幻灯片切换），`initialZoomInEnd`（初始放大动画结束）和 `initialZoomOutEnd`（初始缩小动画结束）。
- 如果启用了放大 / 缩小动画，则在打开 PhotoSwipe 的缩略图上尽量避免复杂的 `:hover` 和 `:active` 效果（应用第一条规则）。
- 确保在滑动区域的 UI 上没有复杂的样式。例如，标题文本上的 `text-shadow` 可能会导致问题。

如果你遵循了上面的步骤，并且你的图库的性能与 [PhotoSwipe home page](http://photoswipe.com) 不同，那么开始在 Page 上隔离 PhotoSwipe ，排除所有与其无关的 JS/CSS/HTML 代码。确保没有任何类型的横幅旋转器在 PhotoSwipe 后面持续运行一些动画。

如果在隔离了 PhotoSwipe –之后仍然无法快速工作，则打开 [issue on GitHub](https://github.com/dimsemenov/PhotoSwipe/issues) 并提供到 [简化测试用例](http://css-tricks.com/reduced-test-cases/) 的链接。

## 包括文件

- 默认的 PhotoSwipe UI 有 `png` 和 `svg` 精灵。默认情况下，只有在打开 PhotoSwipe 后才加载它。为了使控件立即出现，你可以将 Gallery Sprite 与你的网站“主”Sprite 合并，或者通过 CSS 预装它。
- 如果 Gallery 不是页面的主要功能，请推迟 PhotoSwipe JS 文件的加载。
- 合并 JS、Minify 和合并 CSS 文件。

知道如何改进这个页面吗？[建议编辑一下！](https://github.com/dimsemenov/PhotoSwipe/blob/master/website/documentation/responsive-images.md)

<iframe src="http://ghbtns.com/github-btn.html?user=dimsemenov&amp;repo=photoswipe&amp;type=watch&amp;count=true&amp;size=large" allowtransparency="true" frameborder="0" scrolling="0" width="155" height="30" style=""></iframe>
