# 提供 POD 网络路由

调度到节点的 POD 接收来自节点的 POD CIDR 范围的 IP 地址。此时，由于缺少网络 [routes](https://cloud.google.com/compute/docs/vpc/routes)，POD 无法与运行在不同节点上的其他 POD 通信。

在这个实验室中，你将为每个工作节点创建一个路由，该路由将节点的 POD CIDR 范围映射到节点的内部 IP 地址。

> 有 [other ways](https://kubernetes.io/docs/concepts/cluster-administration/networking/#how-to-achieve-this) 实现 Kubernetes 网络模型。

## 路由表

在本节中，你将收集在 `kubernetes-the-hard-way`VPC 网络中创建路由所需的信息。

为每个工作实例打印内部 IP 地址和 POD CIDR 范围:

```
for instance in worker-0 worker-1 worker-2; do
  gcloud compute instances describe ${instance} \
    --format 'value[separator=" "](networkInterfaces[0].networkIP,metadata.items[0].value)'
done
```

> 输出

```
10.240.0.20 10.200.0.0/24
10.240.0.21 10.200.1.0/24
10.240.0.22 10.200.2.0/24
```

## 路线

为每个工作实例创建网络路由:

```
for i in 0 1 2; do
  gcloud compute routes create kubernetes-route-10-200-${i}-0-24 \
    --network kubernetes-the-hard-way \
    --next-hop-address 10.240.0.2${i} \
    --destination-range 10.200.${i}.0/24
done
```

列出 `kubernetes-the-hard-way`VPC 网络中的路由:

```
gcloud compute routes list --filter "network: kubernetes-the-hard-way"
```

> 输出

```
NAME                            NETWORK                  DEST_RANGE     NEXT_HOP                  PRIORITY
default-route-1606ba68df692422  kubernetes-the-hard-way  10.240.0.0/24  kubernetes-the-hard-way   0
default-route-615e3652a8b74e4d  kubernetes-the-hard-way  0.0.0.0/0      default-internet-gateway  1000
kubernetes-route-10-200-0-0-24  kubernetes-the-hard-way  10.200.0.0/24  10.240.0.20               1000
kubernetes-route-10-200-1-0-24  kubernetes-the-hard-way  10.200.1.0/24  10.240.0.21               1000
kubernetes-route-10-200-2-0-24  kubernetes-the-hard-way  10.200.2.0/24  10.240.0.22               1000
```

下一步:[Deploying the DNS Cluster Add-on](12-dns-addon.md)

