# 引导 Kubernetes 工作者节点

在这个实验室中，你将引导三个 Kubernetes 工作节点。将在每个节点上安装以下组件:[runc](https://github.com/opencontainers/runc)，[container networking plugins](https://github.com/containernetworking/cni)，[containerd](https://github.com/containerd/containerd)，[kubelet](https://kubernetes.io/docs/admin/kubelet)，和 [kube-proxy](https://kubernetes.io/docs/concepts/cluster-administration/proxies)。

## 先决条件

这个实验室中的命令必须在每个工作实例上运行:`worker-0`、`worker-1` 和 `worker-2`。使用 `gcloud` 命令登录到每个工作实例。示例:

```
gcloud compute ssh worker-0
```

### 与 TMUX 并行运行命令

[tmux](https://github.com/tmux/tmux/wiki) 可用于同时在多个计算实例上运行命令。请参阅先决条件实验室中的 [与 TMUX 并行运行命令](01-prerequisites.md#running-commands-in-parallel-with-tmux) 部分。

## 为 Kubernetes 工作者节点提供配置

安装操作系统依赖项:

```
{
  sudo apt-get update
  sudo apt-get -y install socat conntrack ipset
}
```

> Socat 二进制支持 `kubectl port-forward` 命令。

### 禁用交换

默认情况下，如果启用 [swap](https://help.ubuntu.com/community/SwapFaq)，Kubelet 将无法启动。为了确保 Kubernetes 能够提供适当的资源分配和服务质量，禁用 swap 是 [recommended](https://github.com/kubernetes/kubernetes/issues/7294)。

验证是否启用了 swap:

```
sudo swapon --show
```

如果输出为 empthy，则不启用 swap。如果启用了 swap，则运行以下命令立即禁用 swap:

```
sudo swapoff -a
```

> 要确保重新启动后 Swap 仍然关闭，请参考你的 Linux 发行版文档。

### 下载并安装工作二进制文件

```
wget -q --show-progress --https-only --timestamping \
  https://github.com/kubernetes-sigs/cri-tools/releases/download/v1.21.0/crictl-v1.21.0-linux-amd64.tar.gz \
  https://github.com/opencontainers/runc/releases/download/v1.0.0-rc93/runc.amd64 \
  https://github.com/containernetworking/plugins/releases/download/v0.9.1/cni-plugins-linux-amd64-v0.9.1.tgz \
  https://github.com/containerd/containerd/releases/download/v1.4.4/containerd-1.4.4-linux-amd64.tar.gz \
  https://storage.googleapis.com/kubernetes-release/release/v1.21.0/bin/linux/amd64/kubectl \
  https://storage.googleapis.com/kubernetes-release/release/v1.21.0/bin/linux/amd64/kube-proxy \
  https://storage.googleapis.com/kubernetes-release/release/v1.21.0/bin/linux/amd64/kubelet
```

创建安装目录:

```
sudo mkdir -p \
  /etc/cni/net.d \
  /opt/cni/bin \
  /var/lib/kubelet \
  /var/lib/kube-proxy \
  /var/lib/kubernetes \
  /var/run/kubernetes
```

安装 worker 二进制文件:

```
{
  mkdir containerd
  tar -xvf crictl-v1.21.0-linux-amd64.tar.gz
  tar -xvf containerd-1.4.4-linux-amd64.tar.gz -C containerd
  sudo tar -xvf cni-plugins-linux-amd64-v0.9.1.tgz -C /opt/cni/bin/
  sudo mv runc.amd64 runc
  chmod +x crictl kubectl kube-proxy kubelet runc 
  sudo mv crictl kubectl kube-proxy kubelet runc /usr/local/bin/
  sudo mv containerd/bin/* /bin/
}
```

### 配置 CNI 网络

检索当前计算实例的 POD CIDR 范围:

```
POD_CIDR=$(curl -s -H "Metadata-Flavor: Google" \
  http://metadata.google.internal/computeMetadata/v1/instance/attributes/pod-cidr)
```

创建 `bridge` 网络配置文件:

```
cat <<EOF | sudo tee /etc/cni/net.d/10-bridge.conf
{
    "cniVersion": "0.4.0",
    "name": "bridge",
    "type": "bridge",
    "bridge": "cnio0",
    "isGateway": true,
    "ipMasq": true,
    "ipam": {
        "type": "host-local",
        "ranges": [
          [{"subnet": "${POD_CIDR}"}]
        ],
        "routes": [{"dst": "0.0.0.0/0"}]
    }
}
EOF
```

创建 `loopback` 网络配置文件:

```
cat <<EOF | sudo tee /etc/cni/net.d/99-loopback.conf
{
    "cniVersion": "0.4.0",
    "name": "lo",
    "type": "loopback"
}
EOF
```

### 配置 ContainerD 

创建 `containerd` 配置文件:

```
sudo mkdir -p /etc/containerd/
```

```
cat << EOF | sudo tee /etc/containerd/config.toml
[plugins]
  [plugins.cri.containerd]
    snapshotter = "overlayfs"
    [plugins.cri.containerd.default_runtime]
      runtime_type = "io.containerd.runtime.v1.linux"
      runtime_engine = "/usr/local/bin/runc"
      runtime_root = ""
EOF
```

创建 `containerd.service`Systemd 单元文件:

```
cat <<EOF | sudo tee /etc/systemd/system/containerd.service
[Unit]
Description=containerd container runtime
Documentation=https://containerd.io
After=network.target

[Service]
ExecStartPre=/sbin/modprobe overlay
ExecStart=/bin/containerd
Restart=always
RestartSec=5
Delegate=yes
KillMode=process
OOMScoreAdjust=-999
LimitNOFILE=1048576
LimitNPROC=infinity
LimitCORE=infinity

[Install]
WantedBy=multi-user.target
EOF
```

### 配置 Kubelet 

```
{
  sudo mv ${HOSTNAME}-key.pem ${HOSTNAME}.pem /var/lib/kubelet/
  sudo mv ${HOSTNAME}.kubeconfig /var/lib/kubelet/kubeconfig
  sudo mv ca.pem /var/lib/kubernetes/
}
```

创建 `kubelet-config.yaml` 配置文件:

```
cat <<EOF | sudo tee /var/lib/kubelet/kubelet-config.yaml
kind: KubeletConfiguration
apiVersion: kubelet.config.k8s.io/v1beta1
authentication:
  anonymous:
    enabled: false
  webhook:
    enabled: true
  x509:
    clientCAFile: "/var/lib/kubernetes/ca.pem"
authorization:
  mode: Webhook
clusterDomain: "cluster.local"
clusterDNS:
  - "10.32.0.10"
podCIDR: "${POD_CIDR}"
resolvConf: "/run/systemd/resolve/resolv.conf"
runtimeRequestTimeout: "15m"
tlsCertFile: "/var/lib/kubelet/${HOSTNAME}.pem"
tlsPrivateKeyFile: "/var/lib/kubelet/${HOSTNAME}-key.pem"
EOF
```

> 当在运行 `systemd-resolved` 的系统上使用 COREDNS 进行服务发现时，`resolvConf` 配置用于避免循环。

创建 `kubelet.service`Systemd 单元文件:

```
cat <<EOF | sudo tee /etc/systemd/system/kubelet.service
[Unit]
Description=Kubernetes Kubelet
Documentation=https://github.com/kubernetes/kubernetes
After=containerd.service
Requires=containerd.service

[Service]
ExecStart=/usr/local/bin/kubelet \\
  --config=/var/lib/kubelet/kubelet-config.yaml \\
  --container-runtime=remote \\
  --container-runtime-endpoint=unix:///var/run/containerd/containerd.sock \\
  --image-pull-progress-deadline=2m \\
  --kubeconfig=/var/lib/kubelet/kubeconfig \\
  --network-plugin=cni \\
  --register-node=true \\
  --v=2
Restart=on-failure
RestartSec=5

[Install]
WantedBy=multi-user.target
EOF
```

### 配置 Kubernetes 代理

```
sudo mv kube-proxy.kubeconfig /var/lib/kube-proxy/kubeconfig
```

创建 `kube-proxy-config.yaml` 配置文件:

```
cat <<EOF | sudo tee /var/lib/kube-proxy/kube-proxy-config.yaml
kind: KubeProxyConfiguration
apiVersion: kubeproxy.config.k8s.io/v1alpha1
clientConnection:
  kubeconfig: "/var/lib/kube-proxy/kubeconfig"
mode: "iptables"
clusterCIDR: "10.200.0.0/16"
EOF
```

创建 `kube-proxy.service`Systemd 单元文件:

```
cat <<EOF | sudo tee /etc/systemd/system/kube-proxy.service
[Unit]
Description=Kubernetes Kube Proxy
Documentation=https://github.com/kubernetes/kubernetes

[Service]
ExecStart=/usr/local/bin/kube-proxy \\
  --config=/var/lib/kube-proxy/kube-proxy-config.yaml
Restart=on-failure
RestartSec=5

[Install]
WantedBy=multi-user.target
EOF
```

### 开始工人服务

```
{
  sudo systemctl daemon-reload
  sudo systemctl enable containerd kubelet kube-proxy
  sudo systemctl start containerd kubelet kube-proxy
}
```

> 请记住在每个工作节点上运行上述命令:`worker-0`、`worker-1` 和 `worker-2`。

## 验证

> 本教程中创建的计算实例将不具有完成本节的权限。在用于创建计算实例的同一台机器上运行以下命令。

列出已注册的 Kubernetes 节点:

```
gcloud compute ssh controller-0 \
  --command "kubectl get nodes --kubeconfig admin.kubeconfig"
```

> 输出

```
NAME       STATUS   ROLES    AGE   VERSION
worker-0   Ready    <none>   22s   v1.21.0
worker-1   Ready    <none>   22s   v1.21.0
worker-2   Ready    <none>   22s   v1.21.0
```

下一步:[为远程访问配置 Kubectl ](10-configuring-kubectl.md)

