# Kubernetes 的艰难之路

本教程将引导你以困难的方式设置 Kubernetes。这本指南不是为那些想要用完全自动化的命令来显示 Kubernetes集群的人准备的。如果是这样，那么查看 [Google Kubernetes 引擎](https://cloud.google.com/kubernetes-engine) 或 [入门指南](https://kubernetes.io/docs/setup)。

Kubernetes 困难的方式是为学习而优化的，这意味着要走一条漫长的路，以确保你理解引导 Kubernetes 所需的每一项任务集群。

> 本教程的结果不应被视为生产准备就绪，并且可能会从社区获得有限的支持，但不要让它阻止你学习！

## 版权

<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br /> 本作品以 <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"> 创用 CC 署名-非商业-ShareAlike4.0 国际许可 </a> 授权。

## 目标受众

本教程的目标受众是计划支持生产 Kubernetes集群的人，他们希望了解所有内容是如何组合在一起的。

## 集群细节

Kubernetes Hard Way 指导你引导一个高可用性的 Kubernetes集群，在组件和 RBAC 身份验证之间进行端到端加密。

* [kubernetes](https://github.com/kubernetes/kubernetes)v1.21.0
* [containerd](https://github.com/containerd/containerd)v1.4.4
* [coredns](https://github.com/coredns/coredns)v1.8.3
* [cni](https://github.com/containernetworking/cni)v0.9.1
* [etcd](https://github.com/etcd-io/etcd)v3.4.15

## 实验室

本教程假定你可以访问 [谷歌云平台](https://cloud.google.com)。虽然 GCP 用于基本的基础设施需求，但本教程中学到的经验教训可以应用于其他平台。

* [Prerequisites](docs/01-prerequisites.md)
* [安装客户端工具](docs/02-client-tools.md)
* [配置计算资源](docs/03-compute-resources.md)
* [设置 CA 并生成 TLS 证书](docs/04-certificate-authority.md)
* [生成 Kubernetes 配置文件以进行身份验证](docs/05-kubernetes-configuration-files.md)
* [生成数据加密配置和密钥](docs/06-data-encryption-keys.md)
* [Bootstrapping the etcd Cluster](docs/07-bootstrapping-etcd.md)
* [启动 Kubernetes 控制飞机](docs/08-bootstrapping-kubernetes-controllers.md)
* [引导 Kubernetes 工作者节点](docs/09-bootstrapping-kubernetes-workers.md)
* [为远程访问配置 Kubectl ](docs/10-configuring-kubectl.md)
* [提供 POD 网络路由](docs/11-pod-network-routes.md)
* [Deploying the DNS Cluster Add-on](docs/12-dns-addon.md)
* [Smoke Test](docs/13-smoke-test.md)
* [Cleaning Up](docs/14-cleanup.md)

