# 为远程访问配置 Kubectl 

在这个实验室中，你将基于 `admin` 用户凭据为 `kubectl` 命令行实用程序生成一个 KubeConfig 文件。

> 从用于生成管理客户机证书的同一目录运行此实验室中的命令。

## 管理 Kubernetes 配置文件

每个 KubeConfig 都需要一个 Kubernetes API 服务器来连接。为了支持高可用性，将使用分配给 Kubernetes API 服务器前的外部负载均衡器的 IP 地址。

生成一个 KubeConfig 文件，该文件适合作为 `admin` 用户进行身份验证:

```
{
  KUBERNETES_PUBLIC_ADDRESS=$(gcloud compute addresses describe kubernetes-the-hard-way \
    --region $(gcloud config get-value compute/region) \
    --format 'value(address)')

  kubectl config set-cluster kubernetes-the-hard-way \
    --certificate-authority=ca.pem \
    --embed-certs=true \
    --server=https://${KUBERNETES_PUBLIC_ADDRESS}:6443

  kubectl config set-credentials admin \
    --client-certificate=admin.pem \
    --client-key=admin-key.pem

  kubectl config set-context kubernetes-the-hard-way \
    --cluster=kubernetes-the-hard-way \
    --user=admin

  kubectl config use-context kubernetes-the-hard-way
}
```

## 验证

检查远程 Kubernetes 的版本集群:

```
kubectl version
```

> 输出

```
Client Version: version.Info{Major:"1", Minor:"21", GitVersion:"v1.21.0", GitCommit:"cb303e613a121a29364f75cc67d3d580833a7479", GitTreeState:"clean", BuildDate:"2021-04-08T16:31:21Z", GoVersion:"go1.16.1", Compiler:"gc", Platform:"linux/amd64"}
Server Version: version.Info{Major:"1", Minor:"21", GitVersion:"v1.21.0", GitCommit:"cb303e613a121a29364f75cc67d3d580833a7479", GitTreeState:"clean", BuildDate:"2021-04-08T16:25:06Z", GoVersion:"go1.16.1", Compiler:"gc", Platform:"linux/amd64"}
```

列出远程 Kubernetes集群中的节点:

```
kubectl get nodes
```

> 输出

```
NAME       STATUS   ROLES    AGE     VERSION
worker-0   Ready    <none>   2m35s   v1.21.0
worker-1   Ready    <none>   2m35s   v1.21.0
worker-2   Ready    <none>   2m35s   v1.21.0
```

下一步:[提供 POD 网络路由](11-pod-network-routes.md)

