# 生成 Kubernetes 配置文件以进行身份验证

在这个实验室中，你将生成 [Kubernetes 配置文件](https://kubernetes.io/docs/concepts/configuration/organize-cluster-access-kubeconfig/)，也称为 KubeConfigs，它使 Kubernetes 客户机能够定位并验证 Kubernetes API 服务器。

## 客户端身份验证配置

在本节中，你将为 `controller manager`、`kubelet`、`kube-proxy` 和 `scheduler` 客户端和 `admin` 用户生成 KubeConfig 文件。

### Kubernetes 公共 IP 地址

每个 KubeConfig 都需要一个 Kubernetes API 服务器来连接。为了支持高可用性，将使用分配给 Kubernetes API 服务器前的外部负载均衡器的 IP 地址。

检索 `kubernetes-the-hard-way` 静态 IP 地址:

```
KUBERNETES_PUBLIC_ADDRESS=$(gcloud compute addresses describe kubernetes-the-hard-way \
  --region $(gcloud config get-value compute/region) \
  --format 'value(address)')
```

### Kubelet Kubernetes 配置文件

在为 Kubelets 生成 KubeConfig 文件时，必须使用与 Kubelets 节点名匹配的客户机证书。这将确保 Kubelets 得到 Kubernetes[Node Authorizer](https://kubernetes.io/docs/admin/authorization/node/) 的适当授权。

> 在 [生成 TLS 证书](04-certificate-authority.md) 实验室期间，必须在用于生成 SSL 证书的同一目录中运行以下命令。

为每个工作节点生成一个 KubeConfig 文件:

```
for instance in worker-0 worker-1 worker-2; do
  kubectl config set-cluster kubernetes-the-hard-way \
    --certificate-authority=ca.pem \
    --embed-certs=true \
    --server=https://${KUBERNETES_PUBLIC_ADDRESS}:6443 \
    --kubeconfig=${instance}.kubeconfig

  kubectl config set-credentials system:node:${instance} \
    --client-certificate=${instance}.pem \
    --client-key=${instance}-key.pem \
    --embed-certs=true \
    --kubeconfig=${instance}.kubeconfig

  kubectl config set-context default \
    --cluster=kubernetes-the-hard-way \
    --user=system:node:${instance} \
    --kubeconfig=${instance}.kubeconfig

  kubectl config use-context default --kubeconfig=${instance}.kubeconfig
done
```

结果:

```
worker-0.kubeconfig
worker-1.kubeconfig
worker-2.kubeconfig
```

### Kube-Proxy Kubernetes 配置文件

为 `kube-proxy` 服务生成一个 KubeConfig 文件:

```
{
  kubectl config set-cluster kubernetes-the-hard-way \
    --certificate-authority=ca.pem \
    --embed-certs=true \
    --server=https://${KUBERNETES_PUBLIC_ADDRESS}:6443 \
    --kubeconfig=kube-proxy.kubeconfig

  kubectl config set-credentials system:kube-proxy \
    --client-certificate=kube-proxy.pem \
    --client-key=kube-proxy-key.pem \
    --embed-certs=true \
    --kubeconfig=kube-proxy.kubeconfig

  kubectl config set-context default \
    --cluster=kubernetes-the-hard-way \
    --user=system:kube-proxy \
    --kubeconfig=kube-proxy.kubeconfig

  kubectl config use-context default --kubeconfig=kube-proxy.kubeconfig
}
```

结果:

```
kube-proxy.kubeconfig
```

### kube-controller-manager Kubernetes 配置文件

为 `kube-controller-manager` 服务生成一个 KubeConfig 文件:

```
{
  kubectl config set-cluster kubernetes-the-hard-way \
    --certificate-authority=ca.pem \
    --embed-certs=true \
    --server=https://127.0.0.1:6443 \
    --kubeconfig=kube-controller-manager.kubeconfig

  kubectl config set-credentials system:kube-controller-manager \
    --client-certificate=kube-controller-manager.pem \
    --client-key=kube-controller-manager-key.pem \
    --embed-certs=true \
    --kubeconfig=kube-controller-manager.kubeconfig

  kubectl config set-context default \
    --cluster=kubernetes-the-hard-way \
    --user=system:kube-controller-manager \
    --kubeconfig=kube-controller-manager.kubeconfig

  kubectl config use-context default --kubeconfig=kube-controller-manager.kubeconfig
}
```

结果:

```
kube-controller-manager.kubeconfig
```

### Kube-Scheduler Kubernetes 配置文件

为 `kube-scheduler` 服务生成一个 KubeConfig 文件:

```
{
  kubectl config set-cluster kubernetes-the-hard-way \
    --certificate-authority=ca.pem \
    --embed-certs=true \
    --server=https://127.0.0.1:6443 \
    --kubeconfig=kube-scheduler.kubeconfig

  kubectl config set-credentials system:kube-scheduler \
    --client-certificate=kube-scheduler.pem \
    --client-key=kube-scheduler-key.pem \
    --embed-certs=true \
    --kubeconfig=kube-scheduler.kubeconfig

  kubectl config set-context default \
    --cluster=kubernetes-the-hard-way \
    --user=system:kube-scheduler \
    --kubeconfig=kube-scheduler.kubeconfig

  kubectl config use-context default --kubeconfig=kube-scheduler.kubeconfig
}
```

结果:

```
kube-scheduler.kubeconfig
```

### 管理 Kubernetes 配置文件

为 `admin` 用户生成一个 kubeconfig 文件:

```
{
  kubectl config set-cluster kubernetes-the-hard-way \
    --certificate-authority=ca.pem \
    --embed-certs=true \
    --server=https://127.0.0.1:6443 \
    --kubeconfig=admin.kubeconfig

  kubectl config set-credentials admin \
    --client-certificate=admin.pem \
    --client-key=admin-key.pem \
    --embed-certs=true \
    --kubeconfig=admin.kubeconfig

  kubectl config set-context default \
    --cluster=kubernetes-the-hard-way \
    --user=admin \
    --kubeconfig=admin.kubeconfig

  kubectl config use-context default --kubeconfig=admin.kubeconfig
}
```

结果:

```
admin.kubeconfig
```

## 

## 分发 Kubernetes 配置文件

将适当的 `kubelet` 和 `kube-proxy`KubeConfig 文件复制到每个工作实例:

```
for instance in worker-0 worker-1 worker-2; do
  gcloud compute scp ${instance}.kubeconfig kube-proxy.kubeconfig ${instance}:~/
done
```

将适当的 `kube-controller-manager` 和 `kube-scheduler`KubeConfig 文件复制到每个控制器实例:

```
for instance in controller-0 controller-1 controller-2; do
  gcloud compute scp admin.kubeconfig kube-controller-manager.kubeconfig kube-scheduler.kubeconfig ${instance}:~/
done
```

下一条:[生成数据加密配置和密钥](06-data-encryption-keys.md)

