# 配置计算资源

Kubernetes 需要一组机器来承载 Kubernetes 控制平面和最终运行容器的工作节点。在这个实验室中，你将提供在单个 [compute zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) 上运行安全且高度可用的 Kubernetes集群所需的计算资源。

> 确保已按照 [Prerequisites](01-prerequisites.md#set-a-default-compute-region-and-zone) 实验室中所述设置了默认的计算区域和区域。

## 网络

Kubernetes[网络模型](https://kubernetes.io/docs/concepts/cluster-administration/networking/#kubernetes-model) 假设了一个平坦的网络，在这个网络中容器和节点可以相互通信。在不希望这样做的情况下，[网络策略](https://kubernetes.io/docs/concepts/services-networking/network-policies/) 可以限制容器组之间允许相互通信和外部网络端点的方式。

> 设置网络策略超出了本教程的范围。

### 虚拟私有云网络

在本节中，将设置一个专用的 [虚拟私有云](https://cloud.google.com/compute/docs/networks-and-firewalls#networks) 网络来承载 Kubernetes集群。

创建 `kubernetes-the-hard-way` 自定义 VPC 网络:

```
gcloud compute networks create kubernetes-the-hard-way --subnet-mode custom
```

a[subnet](https://cloud.google.com/compute/docs/vpc/#vpc_networksandsubnets) 必须配置一个足够大的 IP 地址范围，以便为 Kubernetes 中的每个节点分配一个专用 IP 地址集群。

在 `kubernetes-the-hard-way`VPC 网络中创建 `kubernetes` 子网:

```
gcloud compute networks subnets create kubernetes \
  --network kubernetes-the-hard-way \
  --range 10.240.0.0/24
```

> `10.240.0.0/24`IP 地址范围可以承载多达 254 个计算实例。

### 防火墙规则

创建允许跨所有协议进行内部通信的防火墙规则:

```
gcloud compute firewall-rules create kubernetes-the-hard-way-allow-internal \
  --allow tcp,udp,icmp \
  --network kubernetes-the-hard-way \
  --source-ranges 10.240.0.0/24,10.200.0.0/16
```

创建允许外部 SSH、ICMP 和 HTTPS 的防火墙规则:

```
gcloud compute firewall-rules create kubernetes-the-hard-way-allow-external \
  --allow tcp:22,tcp:6443,icmp \
  --network kubernetes-the-hard-way \
  --source-ranges 0.0.0.0/0
```

> 将使用 [外部负载平衡器](https://cloud.google.com/compute/docs/load-balancing/network/) 向远程客户端公开 Kubernetes API 服务器。

列出 `kubernetes-the-hard-way`VPC 网络中的防火墙规则:

```
gcloud compute firewall-rules list --filter="network:kubernetes-the-hard-way"
```

> 输出

```
NAME                                    NETWORK                  DIRECTION  PRIORITY  ALLOW                 DENY  DISABLED
kubernetes-the-hard-way-allow-external  kubernetes-the-hard-way  INGRESS    1000      tcp:22,tcp:6443,icmp        False
kubernetes-the-hard-way-allow-internal  kubernetes-the-hard-way  INGRESS    1000      tcp,udp,icmp                Fals
```

### Kubernetes 公共 IP 地址

分配一个静态 IP 地址，该地址将附加到 Kubernetes API 服务器前面的外部负载均衡器:

```
gcloud compute addresses create kubernetes-the-hard-way \
  --region $(gcloud config get-value compute/region)
```

验证 `kubernetes-the-hard-way` 静态 IP 地址是在默认计算区域中创建的:

```
gcloud compute addresses list --filter="name=('kubernetes-the-hard-way')"
```

> 输出

```
NAME                     ADDRESS/RANGE   TYPE      PURPOSE  NETWORK  REGION    SUBNET  STATUS
kubernetes-the-hard-way  XX.XXX.XXX.XXX  EXTERNAL                    us-west1          RESERVED
```

## 计算实例

这个实验室中的计算实例将使用 [Ubuntu Server](https://www.ubuntu.com/server)20.04 提供，这对 [containerd container runtime](https://github.com/containerd/containerd) 有很好的支持。将为每个计算实例提供一个固定的专用 IP 地址，以简化 Kubernetes 引导过程。

### Kubernetes 控制器

创建三个将托管 Kubernetes 控制平面的计算实例:

```
for i in 0 1 2; do
  gcloud compute instances create controller-${i} \
    --async \
    --boot-disk-size 200GB \
    --can-ip-forward \
    --image-family ubuntu-2004-lts \
    --image-project ubuntu-os-cloud \
    --machine-type e2-standard-2 \
    --private-network-ip 10.240.0.1${i} \
    --scopes compute-rw,storage-ro,service-management,service-control,logging-write,monitoring \
    --subnet kubernetes \
    --tags kubernetes-the-hard-way,controller
done
```

### Kubernetes 工人

每个工作实例都需要来自 Kubernetes集群CIDR 范围的 POD 子网分配。POD 子网分配将用于在稍后的练习中配置容器网络。将使用 `pod-cidr` 实例元数据公开 POD 子网分配，以便在运行时计算实例。

> Kubernetes集群CIDR 范围由控制器管理器的 `--cluster-cidr` 标志定义。在本教程中，集群CIDR 范围将设置为 `10.200.0.0/16`，它支持 254 个子网。

创建三个将承载 Kubernetes 工作者节点的计算实例:

```
for i in 0 1 2; do
  gcloud compute instances create worker-${i} \
    --async \
    --boot-disk-size 200GB \
    --can-ip-forward \
    --image-family ubuntu-2004-lts \
    --image-project ubuntu-os-cloud \
    --machine-type e2-standard-2 \
    --metadata pod-cidr=10.200.${i}.0/24 \
    --private-network-ip 10.240.0.2${i} \
    --scopes compute-rw,storage-ro,service-management,service-control,logging-write,monitoring \
    --subnet kubernetes \
    --tags kubernetes-the-hard-way,worker
done
```

### 验证

在默认计算区域中列出计算实例:

```
gcloud compute instances list --filter="tags.items=kubernetes-the-hard-way"
```

> 输出

```
NAME          ZONE        MACHINE_TYPE   PREEMPTIBLE  INTERNAL_IP  EXTERNAL_IP    STATUS
controller-0  us-west1-c  e2-standard-2               10.240.0.10  XX.XX.XX.XXX   RUNNING
controller-1  us-west1-c  e2-standard-2               10.240.0.11  XX.XXX.XXX.XX  RUNNING
controller-2  us-west1-c  e2-standard-2               10.240.0.12  XX.XXX.XX.XXX  RUNNING
worker-0      us-west1-c  e2-standard-2               10.240.0.20  XX.XX.XXX.XXX  RUNNING
worker-1      us-west1-c  e2-standard-2               10.240.0.21  XX.XX.XX.XXX   RUNNING
worker-2      us-west1-c  e2-standard-2               10.240.0.22  XX.XXX.XX.XX   RUNNING
```

## 配置 SSH 访问

SSH 将用于配置控制器和工作实例。当第一次连接到计算实例时，SSH 键将为你生成并存储在项目或实例元数据中，如 [连接到实例](https://cloud.google.com/compute/docs/instances/connecting-to-instance)文档中所述。

测试对 `controller-0` 计算实例的 ssh 访问:

```
gcloud compute ssh controller-0
```

如果这是你第一次连接到计算实例，那么将为你生成 SSH 键。在提示符处输入密码以继续:

```
WARNING: The public SSH key file for gcloud does not exist.
WARNING: The private SSH key file for gcloud does not exist.
WARNING: You do not have an SSH key for gcloud.
WARNING: SSH keygen will be executed to generate a key.
Generating public/private rsa key pair.
Enter passphrase (empty for no passphrase):
Enter same passphrase again:
```

此时，生成的 SSH 密钥将被上传并存储在你的项目中:

```
Your identification has been saved in /home/$USER/.ssh/google_compute_engine.
Your public key has been saved in /home/$USER/.ssh/google_compute_engine.pub.
The key fingerprint is:
SHA256:nz1i8jHmgQuGt+WscqP5SeIaSy5wyIJeL71MuV+QruE $USER@$HOSTNAME
The key's randomart image is:
+---[RSA 2048]----+
|                 |
|                 |
|                 |
|        .        |
|o.     oS        |
|=... .o .o o     |
|+.+ =+=.+.X o    |
|.+ ==O*B.B = .   |
| .+.=EB++ o      |
+----[SHA256]-----+
Updating project ssh metadata...-Updated [https://www.googleapis.com/compute/v1/projects/$PROJECT_ID].
Updating project ssh metadata...done.
Waiting for SSH key to propagate.
```

更新了 SSH 键之后，你将登录到 `controller-0` 实例:

```
Welcome to Ubuntu 20.04.2 LTS (GNU/Linux 5.4.0-1042-gcp x86_64)
...
```

在退出 `controller-0` 计算实例的提示符处键入 `exit`:

```
$USER@controller-0:~$ exit
```

> 输出

```
logout
Connection to XX.XX.XX.XXX closed
```

下一条:[设置 CA 并生成 TLS 证书](04-certificate-authority.md)

