# 安装客户端工具

在这个实验室中，你将安装完成本教程所需的命令行实用程序:[cfssl](https://github.com/cloudflare/cfssl)、[cfssljson](https://github.com/cloudflare/cfssl) 和 [kubectl](https://kubernetes.io/docs/tasks/tools/install-kubectl)。

## 安装 CFSSL 

`cfssl` 和 `cfssljson` 命令行实用程序将用于提供 [PKI 基础设施](https://en.wikipedia.org/wiki/Public_key_infrastructure) 并生成 TLS 证书。

下载并安装 `cfssl` 和 `cfssljson`:

### OS X  

```
curl -o cfssl https://storage.googleapis.com/kubernetes-the-hard-way/cfssl/1.4.1/darwin/cfssl
curl -o cfssljson https://storage.googleapis.com/kubernetes-the-hard-way/cfssl/1.4.1/darwin/cfssljson
```

```
chmod +x cfssl cfssljson
```

```
sudo mv cfssl cfssljson /usr/local/bin/
```

一些 OS X 用户在使用预构建的二进制文件时可能会遇到问题，在这种情况下 [Homebrew](https://brew.sh) 可能是一个更好的选择:

```
brew install cfssl
```

### Linux  

```
wget -q --show-progress --https-only --timestamping \
  https://storage.googleapis.com/kubernetes-the-hard-way/cfssl/1.4.1/linux/cfssl \
  https://storage.googleapis.com/kubernetes-the-hard-way/cfssl/1.4.1/linux/cfssljson
```

```
chmod +x cfssl cfssljson
```

```
sudo mv cfssl cfssljson /usr/local/bin/
```

### 验证

验证 `cfssl` 和 `cfssljson` 版本 1.4.1 或更高版本已安装:

```
cfssl version
```

> 输出

```
Version: 1.4.1
Runtime: go1.12.12
```

```
cfssljson --version
```
```
Version: 1.4.1
Runtime: go1.12.12
```

## 安装 Kubectl 

`kubectl` 命令行实用程序用于与 Kubernetes API 服务器交互。从官方发布的二进制文件下载并安装 `kubectl`:

### OS X

```
curl -o kubectl https://storage.googleapis.com/kubernetes-release/release/v1.21.0/bin/darwin/amd64/kubectl
```

```
chmod +x kubectl
```

```
sudo mv kubectl /usr/local/bin/
```

### Linux

```
wget https://storage.googleapis.com/kubernetes-release/release/v1.21.0/bin/linux/amd64/kubectl
```

```
chmod +x kubectl
```

```
sudo mv kubectl /usr/local/bin/
```

### 验证

验证 `kubectl` 版本 1.21.0 或更高版本已安装:

```
kubectl version --client
```

> 输出

```
Client Version: version.Info{Major:"1", Minor:"21", GitVersion:"v1.21.0", GitCommit:"cb303e613a121a29364f75cc67d3d580833a7479", GitTreeState:"clean", BuildDate:"2021-04-08T16:31:21Z", GoVersion:"go1.16.1", Compiler:"gc", Platform:"linux/amd64"}
```

下一条:[配置计算资源](03-compute-resources.md)

