# 启动 ETCD集群

Kubernetes 组件是无状态的，并将集群状态存储在 [etcd](https://github.com/etcd-io/etcd) 中。在这个实验室中，你将引导一个三节点 ETCD集群，并将其配置为高可用性和安全的远程访问。

## 先决条件

该实验室中的命令必须在每个控制器实例上运行:`controller-0`、`controller-1` 和 `controller-2`。使用 `gcloud` 命令登录到每个控制器实例。示例:

```
gcloud compute ssh controller-0
```

### 与 TMUX 并行运行命令

[tmux](https://github.com/tmux/tmux/wiki) 可用于同时在多个计算实例上运行命令。请参阅先决条件实验室中的 [与 TMUX 并行运行命令](01-prerequisites.md#running-commands-in-parallel-with-tmux) 部分。

## 引导 ETCD集群成员

### 下载并安装 ETCD 二进制文件

从 [etcd](https://github.com/etcd-io/etcd)Github 项目下载官方的 ETCD 发行版二进制文件:

```
wget -q --show-progress --https-only --timestamping \
  "https://github.com/etcd-io/etcd/releases/download/v3.4.15/etcd-v3.4.15-linux-amd64.tar.gz"
```

提取并安装 `etcd` 服务器和 `etcdctl` 命令行实用程序:

```
{
  tar -xvf etcd-v3.4.15-linux-amd64.tar.gz
  sudo mv etcd-v3.4.15-linux-amd64/etcd* /usr/local/bin/
}
```

### 配置 ETCD 服务器

```
{
  sudo mkdir -p /etc/etcd /var/lib/etcd
  sudo chmod 700 /var/lib/etcd
  sudo cp ca.pem kubernetes-key.pem kubernetes.pem /etc/etcd/
}
```

实例内部 IP 地址将用于服务客户机请求并与 ETCD集群对等点通信。检索当前计算实例的内部 IP 地址:

```
INTERNAL_IP=$(curl -s -H "Metadata-Flavor: Google" \
  http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ip)
```

每个 ETCD 成员必须在 ETCD 中有一个唯一的名称集群。将 ETCD 名称设置为与当前计算实例的主机名匹配:

```
ETCD_NAME=$(hostname -s)
```

创建 `etcd.service`Systemd 单元文件:

```
cat <<EOF | sudo tee /etc/systemd/system/etcd.service
[Unit]
Description=etcd
Documentation=https://github.com/coreos

[Service]
Type=notify
ExecStart=/usr/local/bin/etcd \\
  --name ${ETCD_NAME} \\
  --cert-file=/etc/etcd/kubernetes.pem \\
  --key-file=/etc/etcd/kubernetes-key.pem \\
  --peer-cert-file=/etc/etcd/kubernetes.pem \\
  --peer-key-file=/etc/etcd/kubernetes-key.pem \\
  --trusted-ca-file=/etc/etcd/ca.pem \\
  --peer-trusted-ca-file=/etc/etcd/ca.pem \\
  --peer-client-cert-auth \\
  --client-cert-auth \\
  --initial-advertise-peer-urls https://${INTERNAL_IP}:2380 \\
  --listen-peer-urls https://${INTERNAL_IP}:2380 \\
  --listen-client-urls https://${INTERNAL_IP}:2379,https://127.0.0.1:2379 \\
  --advertise-client-urls https://${INTERNAL_IP}:2379 \\
  --initial-cluster-token etcd-cluster-0 \\
  --initial-cluster controller-0=https://10.240.0.10:2380,controller-1=https://10.240.0.11:2380,controller-2=https://10.240.0.12:2380 \\
  --initial-cluster-state new \\
  --data-dir=/var/lib/etcd
Restart=on-failure
RestartSec=5

[Install]
WantedBy=multi-user.target
EOF
```

### 启动 ETCD 服务器

```
{
  sudo systemctl daemon-reload
  sudo systemctl enable etcd
  sudo systemctl start etcd
}
```

> 请记住在每个控制器节点上运行上述命令:`controller-0`、`controller-1` 和 `controller-2`。

## 验证

列出 ETCD集群成员:

```
sudo ETCDCTL_API=3 etcdctl member list \
  --endpoints=https://127.0.0.1:2379 \
  --cacert=/etc/etcd/ca.pem \
  --cert=/etc/etcd/kubernetes.pem \
  --key=/etc/etcd/kubernetes-key.pem
```

> 输出

```
3a57933972cb5131, started, controller-2, https://10.240.0.12:2380, https://10.240.0.12:2379, false
f98dc20bce6225a0, started, controller-0, https://10.240.0.10:2380, https://10.240.0.10:2379, false
ffed16798470cab5, started, controller-1, https://10.240.0.11:2380, https://10.240.0.11:2379, false
```

下一条:[启动 Kubernetes 控制飞机](08-bootstrapping-kubernetes-controllers.md)

