# 生成数据加密配置和密钥

Kubernetes 存储各种数据，包括集群状态、应用程序配置和秘密。Kubernetes 支持在静止状态下 [encrypt](https://kubernetes.io/docs/tasks/administer-cluster/encrypt-data)集群数据的能力。

在这个实验室中，你将生成一个加密密钥和一个 [加密配置](https://kubernetes.io/docs/tasks/administer-cluster/encrypt-data/#understanding-the-encryption-at-rest-configuration)，适合于对 Kubernetes 的秘密进行加密。

## 加密密钥

生成加密密钥:

```
ENCRYPTION_KEY=$(head -c 32 /dev/urandom | base64)
```

## 加密配置文件

创建 `encryption-config.yaml` 加密配置文件:

```
cat > encryption-config.yaml <<EOF
kind: EncryptionConfig
apiVersion: v1
resources:
  - resources:
      - secrets
    providers:
      - aescbc:
          keys:
            - name: key1
              secret: ${ENCRYPTION_KEY}
      - identity: {}
EOF
```

将 `encryption-config.yaml` 加密配置文件复制到每个控制器实例:

```
for instance in controller-0 controller-1 controller-2; do
  gcloud compute scp encryption-config.yaml ${instance}:~/
done
```

下一步:[Bootstrapping the etcd Cluster](07-bootstrapping-etcd.md)

