# 先决条件

## 谷歌云平台

本教程利用 [谷歌云平台](https://cloud.google.com/) 来简化从头开始引导 Kubernetes集群所需的计算基础设施的配置。[Sign up](https://cloud.google.com/free/) 可获得 300 美元的免费积分。

[Estimated cost](https://cloud.google.com/products/calculator#id=873932bc-0840-4176-b0fa-a8cfd4ca61ae) 运行此教程:$0.23 per hour ($ 每天 5.50）。

> 本教程所需的计算资源超过了 Google Cloud Platform Free Tier。

## 谷歌云平台 SDK 

### 安装 Google Cloud SDK 

按照 Google Cloud SDK[documentation](https://cloud.google.com/sdk/) 安装和配置 `gcloud` 命令行实用程序。

验证 Google Cloud SDK 版本为 338.0.0 或更高:

```
gcloud version
```

### 设置默认的计算区域和区域

本教程假定已配置了默认的计算区域和区域。

如果你第一次使用 `gcloud` 命令行工具，`init` 是最简单的方法:

```
gcloud init
```

然后，请确保授权 GCloud 使用你的 Google 用户凭据访问云平台:

```
gcloud auth login
```

接下来设置一个默认的计算区域和计算区域:

```
gcloud config set compute/region us-west1
```

设置默认计算区域:

```
gcloud config set compute/zone us-west1-c
```

> 使用 `gcloud compute zones list` 命令查看其他区域和区域。

## 与 TMUX 并行运行命令

[tmux](https://github.com/tmux/tmux/wiki) 可用于同时在多个计算实例上运行命令。本教程中的实验室可能需要在多个计算实例中运行相同的命令，在这些情况下，可以考虑使用 TMUX 并将一个窗口分割为多个窗格，并启用同步窗格以加快供应过程。

> TMUX 的使用是可选的，不需要完成本教程。

![tmux screenshot](images/tmux-screenshot.png)

> 按 `ctrl+b`，然后按 `shift+:`，启用同步窗格。在提示符下键入 `set synchronize-panes on`。要禁用同步:`set synchronize-panes off`。

下一条:[安装客户端工具](02-client-tools.md)

