# 部署 DNS集群插件

在这个实验室中，你将部署 [DNS add-on](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/)，它为运行在 Kubernetes集群中的应用程序提供基于 DNS 的服务发现，并以 [CoreDNS](https://coredns.io/) 为支持。

## DNS集群附加组件

部署 `coredns`集群附加组件:

```
kubectl apply -f https://storage.googleapis.com/kubernetes-the-hard-way/coredns-1.8.yaml
```

> 输出

```
serviceaccount/coredns created
clusterrole.rbac.authorization.k8s.io/system:coredns created
clusterrolebinding.rbac.authorization.k8s.io/system:coredns created
configmap/coredns created
deployment.apps/coredns created
service/kube-dns created
```

列出由 `kube-dns` 部署创建的 pod:

```
kubectl get pods -l k8s-app=kube-dns -n kube-system
```

> 输出

```
NAME                       READY   STATUS    RESTARTS   AGE
coredns-8494f9c688-hh7r2   1/1     Running   0          10s
coredns-8494f9c688-zqrj2   1/1     Running   0          10s
```

## 验证

创建 `busybox` 部署:

```
kubectl run busybox --image=busybox:1.28 --command -- sleep 3600
```

列出由 `busybox` 部署创建的 pod:

```
kubectl get pods -l run=busybox
```

> 输出

```
NAME      READY   STATUS    RESTARTS   AGE
busybox   1/1     Running   0          3s
```

检索 `busybox`pod 的全名:

```
POD_NAME=$(kubectl get pods -l run=busybox -o jsonpath="{.items[0].metadata.name}")
```

在 `busybox`pod 内执行 `kubernetes` 服务的 DNS 查找:

```
kubectl exec -ti $POD_NAME -- nslookup kubernetes
```

> 输出

```
Server:    10.32.0.10
Address 1: 10.32.0.10 kube-dns.kube-system.svc.cluster.local

Name:      kubernetes
Address 1: 10.32.0.1 kubernetes.default.svc.cluster.local
```

下一条:[Smoke Test](13-smoke-test.md)

