# skill_tree_web

`Web 技能树`是[技能森林](https://gitcode.net/csdn/skill_tree)的一部分。

## 初始化

```
pip install -r requirement.txt
```


## 目录结构说明

* 技能树`骨架文件`：
    * 位置：`data/tree.json` 
    * 说明：该文件是执行 `python main.py` 生成的，请勿人工编辑
* 技能树`根节点`配置文件：
    * 位置：`data/config.json`
    * 说明：可编辑配置关键词等字段，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`难度节点`：
    * 位置：`data/xxx`，例如: `data/1.web初阶`
    * 说明：
        * 每个技能树有 3 个等级，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`章节点`：
    * 位置：`data/xxx/xxx`，例如：`data/1.web初阶/1.前端基础`
    * 说明：
        * 每个技能树的每个难度等级有 n 个章节，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`知识节点`：
    * 位置：`data/xxx/xxx/xxx`，例如：`data/1.web初阶/1.前端基础/1.客户端`
    * 说明：
        * 每个技能树的每章有 `n` 个知识节点，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json`
            * 其中 `node_id` 字段是生成的，请勿编辑
            * 其中 `keywords` 可配置关键字字段
            * 其中 `children` 可配置该`知识节点`下的子树结构信息，参考后面描述
            * 其中 `export` 可配置该`知识节点`下的导出习题信息，参考后面描述


## `知识节点` 子树信息结构

例如 `data/1.web初阶/1.前端基础/1.客户端/config.json` 里配置对该知识节点子树信息结构：
```json
{
    // ...

    "children": [
        // TODO ...
    ],
}
```



## `知识节点` 的导出习题编辑

例如 `data/1.web初阶/1.前端基础/1.客户端/config.json` 里配置对该知识节点导出的习题

```json
{
    // ...
    "export": [
        // TODO ...
    ]
}
```

格式说明：
* `file`: 指定该目录下的习题源文件
* `variants`： 指定习题同名的json选项配置文件，参考下一节
* `depends`: 如果习题依赖同目录下的其他习题源代码，则在此字段里配置依赖的其他习题源文件名

## `知识节点` 的导出习题选项配置编辑

首先，在知识节点下增加一个习题代码，例如在 `data/1.web初阶/1.前端基础/1.客户端` 下增加一个`HelloWorld.html`代码：

```web
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<script>
    document.write(Date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

其次，增加一个同名的选项配置文件`HelloWorld.json`，目前有三种配置规则

**单行替换规则**：

* 配置由`one_line`字段指定的单行替换字典
* 格式是：`"<源字符串>"`: [`"<替换字符串A>"`, `<替换字符串B>`,...],
    * 其中每个 `"<源字符串>"` `/` `"<替换字符串A>"` 被生成为是一个替换选项
    * 指定的配置应该能至少生成 `3+` 个替换选项

```json
{
    "one_line": {
        "document.write": ["document.print", "document.out", "document.printf"]
    }
}
```

上面的替换规则会将代码替换成 3 个变种的代码：

```html
// 变种代码1
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<script>
    document.print(Date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

```html
// 变种代码2
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<script>
    document.out(Date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

```html
// 变种代码3
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<script>
    document.printf(Date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

这些变种代码将会作为技能树该知识点该代码选择题的选项。

**多行替换规则**：

* 配置由`multiline`字段指定的多行替换数组
* 数组的每个元素是一组替换规则，会整组被替换

例如：

```json
{
    "mulitiline": [{
        "<script>": "<js>",
        "Date()": "date()"
    },
    { 
        "document.write": "document.printf",
        "<p id=": "<p class="
    },
    {
        "innerHTML": "value"
    }]
}
```

同样，该配置将支持将源代码生成3个变种代码

```html
// 变种代码1
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<js>
    document.write(date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

```html
// 变种代码2, 注意第2组替换规则，包含了两行替换
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p class="test">这是一个测试段落。</p>

<script>
    document.printf(Date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

```html
// 变种代码3
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<script>
    document.write(Date());
    document.getElementById("test").value = "你好,csdn!";
</script>

</body>
</html>
```

## 预制的替换规则

 * 配置由 `prepared` 字段制定的预制文件数组
 * 数组每一个元素是一个预制的代码文件的路径文件名

 例如：

```json
{
    "prepared": [
        "HelloWord.1.html",
        "HelloWord.2.html",
        "HelloWord.3.html"]
}
```

同样，该配置将支持将源代码生成3个变种代码

```html
// HelloWord.1.html
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<js>
    document.write(date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

```html
// 变种代码2, 注意第2组替换规则，包含了两行替换
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p class="test">这是一个测试段落。</p>

<script>
    document.printf(Date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

```html
// 变种代码3
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<script>
    document.write(Date());
    document.getElementById("test").value = "你好,csdn!";
</script>

</body>
</html>
```

## 使用 markdown 编写习题

如前内容，我们在知识节点下增加一个习题配置，例如在 `data/1.web初阶/1.前端基础/1.客户端` 下增加一个`HelloWorld.json`代码：

```json
{
    "type": "code_options",
    "author": "刘鑫",
    "source": "HelloWorld.md",
    "exercise_id":"1190bb7834904da0b1f20915960714d5",
    "notebook_enable": true
}
```
其中 type 字段目前都固定是 `code_options`。exercise_id 可以不写，处理程序会自动填补这个数据。根据具体情况写好其它字段，注意这里 source 的文件名，我们指定了一个 markdwon 文件。现在我们新建一个 HelloWorld.md 并编辑为：

````markdown
# Hello World


以下 `Hello World` html代码中，能够正确显示预期内容的是：

## 答案

```html

<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<script>
    document.write(Date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

## 选项

### A

```html

<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<js>
    document.write(date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

### B

```html

<html>
<body>
<head>
    <title>just a test</title>
</head>

<p class="test">这是一个测试段落。</p>

<script>
    document.printf(Date());
    document.getElementById("test").innerHTML = "你好,csdn!";
</script>

</body>
</html>
```

### C

```html
<html>
<body>
<head>
    <title>just a test</title>
</head>

<p id="test">这是一个测试段落。</p>

<script>
    document.write(Date());
    document.getElementById("test").value = "你好,csdn!";
</script>

</body>
</html>

```

````

这是一个最基本的习题结构，它包含标题、答案、选项，注意这几个一级和二级标题必须填写正确，解释器会读取这几个标题。而选项的标题会被直接忽略掉，在
最终生成的习题中不包含选项的三级标题，所以这个标题可以用来标注一些编辑信息，例如“此选项没有关闭文件连接”，“类型错误”等等。


## 增强信息

为了编写习题和生成 notebook 的需要，markdown 解释器支持两种模板能力，如果我们在答案之前，有一个名为 aop 的二级标题：

````markdown

## aop

### before

```html
document.write("do something before");
```

### after

```html
document.write("do something after");
```
````

那么在创建notebook的时候，before 会插入到源代码前一个单元，after 则会插入到源代码后。aop 章节可以只包含 before 或 after 中的某一个，也可以两个都有。

另一些情况下，我们可能需要把各个选项中重复的代码提取出来，建立一个模板，此时可以在答案之前建立一个名为 template 的二级标题，例如：

````markdwon

## template

```html
<html>
<body>
<head>
    <title>just a test</title>
</head>

// 下面的 code 占位符会被替换成答案和选项代码
$code

</body>
</html>
```

````

注意这里的代码中，有一个 `$code` 占位符，它在管道程序处理过程中，会替换成答案和个选项内容中的代码。

在后续的数据处理流程中，markdown 会被编译为 prepared 类型的习题。



## 技能树合成

在根目录下执行 `python main.py` 会合成技能树文件，合成的技能树文件: `data/tree.json`
* 合成过程中，会自动检查每个目录下 `config.json` 里的 `node_id` 是否存在，不存在则生成
* 合成过程中，会自动检查每个知识点目录下 `config.json` 里的 `export` 里导出的习题配置，检查是否存在`exercise_id` 字段，如果不存在则生成
