# axios的基本用法

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>
Axios 是一个基于 promise 的 HTTP 库，可以用在浏览器和 node.js 中。我们常用在Vue项目中去请求后端接口获取数据；
<br/>


![在这里插入图片描述](https://img-blog.csdnimg.cn/1f1c548bc9204941bae15c7b58e838df.png)
<br/>

<br>
安装使用 npm:

```php
$ npm install axios
```

使用 bower:

```php
$ bower install axios
```

使用 cdn:

```php
<script src="https://unpkg.com/axios/dist/axios.min.js"></script>
```

<br>

**案例**
<br>

执行 GET 请求

```javascript
// 为给定 ID 的 user 创建请求
axios.get('/user?ID=12345')
  .then(function (response) {
    console.log(response);
  })
  .catch(function (error) {
    console.log(error);
  });

// 上面的请求也可以这样做
axios.get('/user', {
    params: {
      ID: 12345
    }
  })
  .then(function (response) {
    console.log(response);
  })
  .catch(function (error) {
    console.log(error);
  });

```
执行 POST 请求

```javascript
axios.post('/user', {
    firstName: 'Fred',
    lastName: 'Flintstone'
  })
  .then(function (response) {
    console.log(response);
  })
  .catch(function (error) {
    console.log(error);
  });
```

执行多个并发请求

```javascript
function getUserAccount() {
  return axios.get('/user/12345');
}

function getUserPermissions() {
  return axios.get('/user/12345/permissions');
}

axios.all([getUserAccount(), getUserPermissions()])
  .then(axios.spread(function (acct, perms) {
    // 两个请求现在都执行完成
  }));
```



<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>

请将这句话补充完整：axios 的是一种`（__1__）`请求，用法和ajax类似，安装npm install axios --save 即可使用，请求中包括`(__2__)`等五种请求方式<br/><br/>

## 答案

1、异步；2、get,post,put, patch ,delete

## 选项

### A

1、同步；2、get,post,put, patch ,delete

### B

1、异步；2、get,post,put, play,delete

### C


1、同步；2、get,post,put, play,delete


