# 组合式API

<div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

**组合式API**
可以通过调用 useStore 函数，来在 setup 钩子函数中访问 store。这与在组件中使用选项式 API 访问 this.$store 是等效的。

```javascript
import { useStore } from 'vuex'

export default {
  setup () {
    const store = useStore()
  }
}
```

**访问 State 和 Getter**

为了访问 state 和 getter，需要创建 computed 引用以保留响应性，这与在选项式 API 中创建计算属性等效。

```javascript
import { computed } from 'vue'
import { useStore } from 'vuex'

export default {
  setup () {
    const store = useStore()

    return {
      // 在 computed 函数中访问 state
      count: computed(() => store.state.count),

      // 在 computed 函数中访问 getter
      double: computed(() => store.getters.double)
    }
  }
}
```

**访问 Mutation 和 Action**

要使用 mutation 和 action 时，只需要在 setup 钩子函数中调用 commit 和 dispatch 函数。

```javascript
import { useStore } from 'vuex'

export default {
  setup () {
    const store = useStore()

    return {
      // 使用 mutation
      increment: () => store.commit('increment'),

      // 使用 action
      asyncIncrement: () => store.dispatch('asyncIncrement')
    }
  }
}
```

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>


关于vuex的说法不正确的是？<br/><br/>

## 答案

actions可以直接操作修改state中的数据

## 选项

### A

actions接收到这个事件之后，在actions中可以执行一些异步或同步操作，actions通过commit去触发mutations

### B

通过dispatch去提交一个actions

### C

mutations去更新state数据，state更新之后，就会通知vue进行渲染
