# 注册自定义指令

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
 
我们通常用的文本框当我们进入页面后需要点击后才会获取焦点的，但是我们可以自定义一个指令为 input ，当页面进入后自动获取焦点，下面就是一个简单的自定义指令的小案例啦  大家可以尝试一下哦！

<br>

```html
<body>
  <div id="app">
    <p>请输入你的幸运数字</p>

    <input v-focus type="text" v-model="num">
    <p>{{text}}</p>
  </div>
</body>
```

<br>

```javascript

<script>
  var app = new Vue({
    el: '#app',
    data: {
      message: '你好，几何心凉!',
      a: 3,
      num: '',
      text: '',
    },
    directives: {
      focus: {
        // 指令的定义
        inserted: function (el) {
          el.focus()
        }
      }
    },
  })

</script>

```
<br>

上面这种是简单的我们从页面中去定义指令，如果运用较多我们可以进行全局注册

<br>

```javascript
// 注册一个全局自定义指令 `v-focus`
Vue.directive('focus', {
  // 当被绑定的元素插入到 DOM 中时……
  inserted: function (el) {
    // 聚焦元素
    el.focus()
  }
})
```

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>
vue的自定义指令错误的是？<br/><br/>

## 答案

oldVNode：上一个VNode，只在update钩子函数中有效。

## 选项

### A

bind函数：只调用一次，指令第一次绑定在元素上调用，即初始化调用一次。

### B

inserted函数：并绑定元素插入父级元素（即new vue中el绑定的元素）时调用（此时父级元素不一定转化为了dom）。

### C

update函数：在元素发生更新时就会调用，可以通过比较新旧的值来进行逻辑处理。
