# webpack的基本使用

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

**项目目录并初始化**
<br>
创建项目，并打开项目所在目录的终端，输入命令：
	
 > npm init -y

**创建首页及js文件**
<br>
在项目目录中创建index.html页面，并初始化页面结构：在页面中摆放一个ul，ul里面放置几个li，在项目目录中创建js文件夹，并在文件夹中创建index.js文件

**以jQuery为例安装jQuery**
<br>
打开项目目录终端，输入命令:
>npm install jQuery -S

**导入jQuery**
<br>
打开index.js文件，编写代码导入jQuery并实现功能：

```javascript
import $ from "jquery";
$(function(){
    $("li:odd").css("background","cyan");
    $("li:odd").css("background","pink");
})
```
注意：此时项目运行会有错误，因为`import $ from "jquery"`;这句代码属于ES6的新语法代码，在浏览器中可能会存在兼容性问题，所以我们需要webpack来帮助我们解决这个问题。

**安装webpack**
<br>
1.打开项目目录终端，输入命令:

```javascript
npm install webpack webpack-cli -D
```

2.然后在项目根目录中，创建一个 webpack.config.js 的配置文件用来配置webpack
<br>
在 webpack.config.js 文件中编写代码进行webpack配置，如下：

```javascript
module.exports = {
    mode:"development"
}
```

补充：mode设置的是项目的编译模式。
<br>
3. 修改项目中的package.json文件添加运行脚本dev，如下：

```javascript
"scripts":{
    "dev":"webpack"
}	
```

	
注意：scripts节点下的脚本，可以通过 npm run 运行，如：

```javascript
运行终端命令：npm run dev
```

将会启动webpack进行项目打包
<br>
4. 运行dev命令进行项目打包，并在页面中引入项目打包生成的js文件
打开项目目录终端，输入命令:

```javascript
npm run dev
```

等待webpack打包完毕之后，找到默认的dist路径中生成的main.js文件，将其引入到html页面中。浏览页面查看效果。

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>

关于webpack.config.js中的mode的参数描述正确的是?<br/><br/>

## 答案

参数可以设置为development，则表示项目处于开发阶段，不会进行压缩和混淆；

## 选项

### A

参数可以设置为production，则表示项目处于开发阶段，不会进行压缩和混淆；

### B

development会进行压缩和混淆，会比production打包速度慢一些

### C

不可以设置