# Vue修饰符

 <div style="color: pink;">小常识：</div>

**事件修饰符**
在事件处理程序中调用 event.preventDefault() 或 event.stopPropagation() 是非常常见的需求。尽管我们可以在方法中轻松实现这点，但更好的方式是：方法只有纯粹的数据逻辑，而不是去处理 DOM 事件细节。

**按键修饰符**
在监听键盘事件时，我们经常需要检查详细的按键。Vue 允许为 v-on 在监听键盘事件时添加按键修饰符：

```html
<!-- 只有在 `key` 是 `Enter` 时调用 `vm.submit()` -->
<input v-on:keyup.enter="submit">
```

你可以直接将 KeyboardEvent.key 暴露的任意有效按键名转换为 kebab-case 来作为修饰符。

```html
<input v-on:keyup.page-down="onPageDown">
```

在上述示例中，处理函数只会在 $event.key 等于 PageDown 时被调用。


**系统修饰键**
![在这里插入图片描述](https://img-blog.csdnimg.cn/e89305e0ac7c4410b17911523e841e47.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)


<br>

 <div style="color: pink;">小测试：</div >

下列对vue常用的修饰符描述错误的是？<br/><br/>

## 答案

.self：触发自己范围内的事件，包含子元素；

## 选项

### A

.capture：与事件冒泡的方向相反，事件捕获由外到内；
  
### B

.prevent：等同于JavaScript中的event.preventDefault()，防止执行预设的行为（如果事件可取消，则取消该事件，而不停止事件的进一步传播

### C

.stop：等同于JavaScript中的event.stopPropagation()，防止事件冒泡
