# computed函数、watch函数

```javaScript
<template>
  <div>
    <input v-model="state.firstName">
    <input v-model="state.lastName">
    <p>{{ fullName }}</p>
  </div>
</template>

<script>
  import { computed, watch, reactive } from 'vue';

  export default {
    setup() {
      const state = reactive({
        firstName: '',
        lastName: ''
      });

      const fullName = computed(() => {
        return `${state.firstName} ${state.lastName}`;
      });

      watch(() => state.firstName, (newVal, oldVal) => {
        console.log(`firstName changed from ${oldVal} to ${newVal}`);
      });

      watch(() => state.lastName, (newVal, oldVal) => {
        console.log(`lastName changed from ${oldVal} to ${newVal}`);
      });

      return {
        state,
        fullName
      };
    }
  };
</script>
```

观察上面代码段，如果我们在第一个输入框中输入'几何'那控制台的打印应该是？

## 答案

firstName changed from  to 几何

## 选项

### A

没有输出任何内容

### B

firstName changed from null to 几何

### C

lastName changed from   to <br />
firstName changed from null to 几何

