# 自定义选项策略

为一个Vue应用程序编写一个混入对象，该混入对象需要有一个名为title的选项。你想要自定义选项策略以确保title选项始终具有正确的值。以下哪种选项策略是正确的？


## 答案

使用Vue.config.optionMergeStrategies来覆盖title选项的默认合并策略，然后在自定义合并函数中始终返回混入对象的title值。

## 选项

### A

在混入对象中定义一个名为title的函数，并在该函数中返回混入对象的title值。然后，在创建Vue实例时，将该函数作为title选项的值传递给Vue构造函数。

### B

在混入对象中定义一个名为title的监听器函数，并在该函数中返回混入对象的title值。然后，在使用混入对象的组件中，使用 watch 选项将该函数添加到组件的选项中。

### C

在混入对象中定义一个名为title的计算属性，并在该计算属性中返回混入对象的title值。然后，在使用混入对象的组件中，将该计算属性添加到组件的computed选项中。

