# 函数式组件

```javaScript

// 创建一个全局混入对象
Vue.mixin({
  created: function () {
    console.log('全局混入对象已创建')
  }
})

// 创建一个组件
var myComponent = Vue.extend({
  created: function () {
    console.log('组件已创建')
  }
})

// 使用组件
new myComponent()

```

上面的代码展示了如何在Vue中创建一个全局混入对象。这段代码会输出什么？

## 答案

会先输出“全局混入对象已创建”，然后输出“组件已创建”。

## 选项

### A

只会输出“组件已创建”。

### B

只会输出“全局混入对象已创建”。

### C

会先输出“组件已创建”，然后输出“全局混入对象已创建”。

