# 安装webpack


在webpack 4.x中，默认会将 src/index.js 作为默认的打包入口js文件，默认会将dist/main.js 作为默认的打包输出js文件，如果不想使用默认的入口/出口js文件我们如何设置？<br/><br/>

## 答案

通过设置 webpack.config.js
```javascript
const path = require("path");
module.exports = {
    mode:"development",
    //设置入口文件路径
    entry: path.join(__dirname,"./src/xx.js"),
    //设置出口文件
    output:{
        //设置路径
        path:path.join(__dirname,"./dist"),
        //设置文件名
        filename:"res.js"
    }
}
```


## 选项

### A

通过设置 vue.config.js
```javascript
const path = require("path");
module.exports = {
    mode:"development",
    //设置入口文件路径
    entry: path.join(__dirname,"./src/xx.js"),
    //设置出口文件
    output:{
        //设置路径
        path:path.join(__dirname,"./dist"),
        //设置文件名
        filename:"res.js"
    }
}
```


### B

通过 main.js 中添加下列代码即可
```javascript
const path = require("path");
module.exports = {
    mode:"development",
    //设置入口文件路径
    entry: path.join(__dirname,"./src/xx.js"),
    //设置出口文件
    output:{
        //设置路径
        path:path.join(__dirname,"./dist"),
        //设置文件名
        filename:"res.js"
    }
}
```


### C

不可以设置