# 全局与局部组件


```javascript
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Document</title>
  <script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>
</head>

<body>
  <div id="app">
    <aabb-c></aabb-c>
  </div>
</body>
<script>
  var app = new Vue({
    el: '#app',
    data: {
      message: '你好，几何心凉!',
      a: 3,
      num: '',
      text: '',
    },
    directives: {
      focus: {
        // 指令的定义
        inserted: function (el) {
          el.focus()
        }
      }
    },
  })

  Vue.component('aabb-c',{
      template:'<p>我是p</p>'
  })
</script>

</html>
```
**运行会报错**</br></br>
<br/>![在这里插入图片描述](https://img-blog.csdnimg.cn/113a151dfcbb496f9378f29f5621b98f.png)
<br/>


<br>


观察上面代码，导致报错的原因是？<br/><br/>

## 答案

因为Vue实例和组件注册的顺序反了，要先注册组件后创建实例

## 选项

### A

不能使用`<aabb-c></aabb-c>`应该改成`<aabbC></aabb-c>`

### B

因为代码中添加了 directives 指令相关函数

### C

因为名字重复了
