# vue.config.js的配置

 <div style="color: pink;">小常识：</div>
<br>

当我们使用cli脚手架创建好vue项目后，我们还需要新建一个js文件  `vue.config.js` 是一个可选的配置文件，如果项目的 (和 package.json 同级的) 根目录中存在这个文件，那么它会被 @vue/cli-service 自动加载。你也可以使用 package.json 中的 vue 字段，但是注意这种写法需要你严格遵照 JSON 的格式来写。
![在这里插入图片描述](https://img-blog.csdnimg.cn/b9a935a4be054a3a9dff66ae2a1c00e8.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_12,color_FFFFFF,t_70,g_se,x_16)
脚手架默认是不会添加这个文件的，但是我们对于Vue的一些全局配置，以及我们开发过程中的代理都是可以写在这里的
![在这里插入图片描述](https://img-blog.csdnimg.cn/e8e79d8bbba44cf9b16c5babbbe7b5a0.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)
可配置项

**publicPath** 
 部署应用包时的基本 URL， 用法和 webpack 本身的 output.publicPath 一致。
这个值也可以被设置为空字符串 ('') 或是相对路径 ('./')，这样所有的资源都会被链接为相对路径，这样打出来的包可以被部署在任意路径。

**outputDir**
输出文件目录，当运行 vue-cli-service build 时生成的生产环境构建文件的目录。注意目标目录在构建之前会被清除 (构建时传入 --no-clean 可关闭该行为)。

**assetsDir**
放置生成的静态资源 (js、css、img、fonts) 的目录。

**indexPath**
指定生成的 index.html 的输出路径 (相对于 outputDir)。也可以是一个绝对路径。
默认情况下，生成的静态资源在它们的文件名中包含了 hash 以便更好的控制缓存。然而，这也要求 index 的 HTML 是被 Vue CLI 自动生成的。如果你无法使用 Vue CLI 生成的 index HTML，你可以通过将这个选项设为 false 来关闭文件名哈希。

**pages**
值是一个对象
在 multi-page（多页）模式下构建应用。每个“page”应该有一个对应的 JavaScript 入口文件。

**lintOnSave**
是否在保存的时候使用 `eslint-loader` 进行检查。 有效的值：`ture` | `false` | `"error"`  当设置为 `"error"` 时，检查出的错误会触发编译失败。

**devServer.proxy**
如果你的前端应用和后端 API 服务器没有运行在同一个主机上，你需要在开发环境下将 API 请求代理到 API 服务器。这个问题可以通过 vue.config.js 中的 devServer.proxy 选项来配置。

**pluginOptions**
这是一个不进行任何 schema 验证的对象，因此它可以用来传递任何第三方插件选项

等等等等
<br>

 <div style="color: pink;">小测试：</div >



根据上方小常识，以下关于vue.config.js说法不正确的是？<br/><br/>

## 答案

indexPath属性是用来指定生成的 index.html 的输出路径，必须是绝对路径

## 选项

### A

vue.config.js文件它会被 @vue/cli-service 自动加载

### B

每一个vue.config.js文件中必须要有module.exports

### C

outputDir属性设置设置输出文件目录，运行vue-cli-service build时生成的生产环境构建文件的目录
