# VueX核心内容

 <div style="color: pink;">小常识：</div>
<br>

**State**
State提供唯一的公共数据源，所有共享的数据都要统一放到Store中的State中存储

**在组件中访问State的方式：**

```javascript
1).this.$store.state.全局数据名称  如：this.$store.state.count
2).先按需导入mapState函数： import { mapState } from 'vuex'
然后数据映射为计算属性： computed:{ ...mapState(['全局数据名称']) }
```
**Mutation**
Mutation用于修改变更$store中的数据

**使用方式第一种**

打开store.js文件，在mutations中添加代码如下

```javascript
mutations: {
    add(state,step){
      //第一个形参永远都是state也就是$state对象
      //第二个形参是调用add时传递的参数
      state.count+=step;
    }
  }
```
然后在Addition.vue中给按钮添加事件代码如下：

```javascript
<button @click="Add">+1</button>

methods:{
  Add(){
    //使用commit函数调用mutations中的对应函数，
    //第一个参数就是我们要调用的mutations中的函数名
    //第二个参数就是传递给add函数的参数
    this.$store.commit('add',10)
  }
}
```
**使用mutations的第二种方式：**

```javascript
import { mapMutations } from 'vuex'

methods:{
  ...mapMutations(['add'])
}

```

```javascript
import { mapState,mapMutations } from 'vuex'

export default {
  data() {
    return {}
  },
  methods:{
      //获得mapMutations映射的sub函数
      ...mapMutations(['sub']),
      //当点击按钮时触发Sub函数
      Sub(){
          //调用sub函数完成对数据的操作
          this.sub(10);
      }
  },
  computed:{
      ...mapState(['count'])
      
  }
}
```
**Action**
在mutations中不能编写异步的代码，会导致vue调试器的显示出错。
在vuex中我们可以使用Action来执行异步操作。

**操作步骤第一种**
打开store.js文件，修改Action，如下：

```javascript
actions: {
  addAsync(context,step){
    setTimeout(()=>{
      context.commit('add',step);
    },2000)
  }
}
```
然后在Addition.vue中给按钮添加事件代码如下

```javascript
<button @click="AddAsync">...+1</button>

methods:{
  AddAsync(){
    this.$store.dispatch('addAsync',5)
  }
}
```

**操作步骤第二种**

```javascript
import { mapActions } from 'vuex'

methods:{
  ...mapMutations(['subAsync'])
}

```

```javascript
import { mapState,mapMutations,mapActions } from 'vuex'

export default {
  data() {
    return {}
  },
  methods:{
      //获得mapMutations映射的sub函数
      ...mapMutations(['sub']),
      //当点击按钮时触发Sub函数
      Sub(){
          //调用sub函数完成对数据的操作
          this.sub(10);
      },
      //获得mapActions映射的addAsync函数
      ...mapActions(['subAsync']),
      asyncSub(){
          this.subAsync(5);
      }
  },
  computed:{
      ...mapState(['count'])
      
  }
}
```
**Getter**
Getter用于对Store中的数据进行加工处理形成新的数据
它只会包装Store中保存的数据，并不会修改Store中保存的数据，当Store中的数据发生变化时，Getter生成的内容也会随之变化

**使用** 
打开store.js文件，添加getters，然后打开Addition.vue中，添加插值表达式使用getters

```javascript
export default new Vuex.Store({
  .......
  getters:{
    //添加了一个showNum的属性
    showNum : state =>{
      return '最新的count值为：'+state.count;
    }
  }
})
```
或者也可以在Addition.vue中，导入mapGetters，并将之映射为计算属性

```javascript
import { mapGetters } from 'vuex'
computed:{
  ...mapGetters(['showNum'])
}

<br>

 <div style="color: pink;">小测试：</div >


根据上方资料，以下关于vuex的核心功能说法不正确的是？<br/><br/>

## 答案

Getters是计算属性，类似组件的计算属性，计算结果不会缓存

## 选项

### A

Mutations唯一能够对state进行修改的地方，在页面中用this.$store.commit（）调用

### B

State是vuex的仓库，存放状态是vuex存放数据的地方

### C

Action是异步操作，可以对Mutations中的方法进行操作
