# Vue指令

 <div style="color: pink;">小常识：</div>
 
 Vue指令在我们开发中使用占比很大的一部分，它让我们对数据在Dom渲染过程中起到润滑作用，巧妙的使用Vue指令让我们Dom渲染更加灵活，在某些业务的实现中Vue指令也是不可或缺的！让我们看看哪些常见的Vue指令吧！
**v-text**
更新元素的 textContent。如果要更新部分的 textContent，需要使用 {{ Mustache }} 插值。
示例：
```html
<span v-text="msg"></span>
<!-- 和下面的一样 -->
<span>{{msg}}</span>
```
**v-html**
更新元素的 innerHTML。注意：内容按普通 HTML 插入 - 不会作为 Vue 模板进行编译。如果试图使用 v-html 组合模板，可以重新考虑是否通过使用组件来替代。

```html
<div v-html="html"></div>
```
**v-show**
根据表达式之真假值，切换元素的 display CSS property。

当条件变化时该指令触发过渡效果。

```html
<div v-show="isShow"></div>
```
**v-if v-else**
根据表达式的值的 truthiness 来有条件地渲染元素。在切换时元素及它的数据绑定 / 组件被销毁并重建。

```html
<div v-if="Math.random() > 0.5">
  Now you see me
</div>
<div v-else>
  Now you don't
</div>
```
**v-for**
基于源数据多次渲染元素或模板块。此指令之值，必须使用特定语法 alias in expression，为当前遍历的元素提供别名：
```html
<div v-for="item in items">
  {{ item.text }}
</div>
```
另外也可以为数组索引指定别名 (或者用于对象的键)：

```html
<div v-for="(item, index) in items"></div>
<div v-for="(val, key) in object"></div>
<div v-for="(val, name, index) in object"></div>
```
后面还有v-on  v-bind  v-model v-slot v-pre v-cloak等指令，大家可以在下面自己去尝试他们巧妙的作用
<br>

 <div style="color: pink;">小测试：</div >

看到上面众多Vue指令，我们可以想到 v-show和v-if都是根据绑定一个布尔值来切换dom的展示，那么他们有区别吗？<br/><br/>

## 答案

有区别，v-show是根据条件为Dom元素添加 display:none 与否来实现的；而v-if是根据条件操作绑定Dom是否存留在Dom树上实现的

## 选项

### A

没有区别

### B

有区别，v-if是根据条件为Dom元素添加 display:none 与否来实现的；而v-show是根据条件操作绑定Dom是否存留在Dom树上实现的

### C

有区别，v-show是根据条件为Dom元素修改 display的值为none还是为block来实现的；而v-if是根据条件操作绑定Dom是否存留在Dom树上实现的
