# VueX是什么

 <div style="color: pink;">小常识：</div>
<br>

**什么是vuex**
Vuex是实现组件全局状态（数据）管理的一种机制，可以方便的实现组件之间的数据共享，是一个专为 Vue.js 应用程序开发的状态管理模式 + 库。它采用集中式存储管理应用的所有组件的状态，并以相应的规则保证状态以一种可预测的方式发生变化。

**状态管理模式**

让我们从一个简单的 Vue 计数应用开始：
```javascript
const Counter = {
  // 状态
  data () {
    return {
      count: 0
    }
  },
  // 视图
  template: `
    <div>{{ count }}</div>
  `,
  // 操作
  methods: {
    increment () {
      this.count++
    }
  }
}

createApp(Counter).mount('#app')
```
这个状态自管理应用包含以下几个部分：

状态，驱动应用的数据源；
视图，以声明方式将状态映射到视图；
操作，响应在视图上的用户输入导致的状态变化。
以下是一个表示“单向数据流”理念的简单示意：
![在这里插入图片描述](https://img-blog.csdnimg.cn/1aff3691c4c24274bf9d93ae04269acd.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_18,color_FFFFFF,t_70,g_se,x_16)
但是，当我们的应用遇到多个组件共享状态时，单向数据流的简洁性很容易被破坏：

多个视图依赖于同一状态。
来自不同视图的行为需要变更同一状态。
对于问题一，传参的方法对于多层嵌套的组件将会非常繁琐，并且对于兄弟组件间的状态传递无能为力。对于问题二，我们经常会采用父子组件直接引用或者通过事件来变更和同步状态的多份拷贝。以上的这些模式非常脆弱，通常会导致无法维护的代码。

因此，我们为什么不把组件的共享状态抽取出来，以一个全局单例模式管理呢？在这种模式下，我们的组件树构成了一个巨大的“视图”，不管在树的哪个位置，任何组件都能获取状态或者触发行为！

通过定义和隔离状态管理中的各种概念并通过强制规则维持视图和状态间的独立性，我们的代码将会变得更结构化且易维护。

这就是 Vuex 背后的基本思想，借鉴了 Flux、Redux 和 The Elm Architecture。与其他模式不同的是，Vuex 是专门为 Vue.js 设计的状态管理库，以利用 Vue.js 的细粒度数据响应机制来进行高效的状态更新。

**Vuex管理数据的优点**

A.能够在vuex中集中管理共享的数据，便于开发和后期进行维护

B.能够高效的实现组件之间的数据共享，提高开发效率

C.存储在vuex中的数据是响应式的，当数据发生改变时，页面中的数据也会同步更新

<br>

<div style="color: pink;">小测试：</div >


根据上方小常识，以下关于VueX的说法不正确的是？<br/><br/>

## 答案

Vuex无法使多个组件共享状态

## 选项

### A

Vuex 是一个专为 Vue.js 应用程序开发的状态管理模式 + 库

### B

它采用集中式存储管理应用的所有组件的状态

### C

Vuex 以相应的规则保证状态以一种可预测的方式发生变化
