# 安装webpack

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

1.打开项目目录终端，输入命令:

```javascript
npm install webpack webpack-cli -D
```

2.然后在项目根目录中，创建一个 webpack.config.js 的配置文件用来配置webpack
<br>
在 webpack.config.js 文件中编写代码进行webpack配置，如下：

```javascript
module.exports = {
    mode:"development"//可以设置为development(开发模式)，production(发布模式)
}
```

补充：mode设置的是项目的编译模式。
<br>
如果设置为development则表示项目处于开发阶段，不会进行压缩和混淆，打包速度会快一些，如果设置为production则表示项目处于上线发布阶段，会进行压缩和混淆，打包速度会慢一些
<br>
3. 修改项目中的package.json文件添加运行脚本dev，如下：

```javascript
"scripts":{
    "dev":"webpack"
}	
```

	
注意：scripts节点下的脚本，可以通过 npm run 运行，如：

```javascript
运行终端命令：npm run dev
```

将会启动webpack进行项目打包
<br>
4. 运行dev命令进行项目打包，并在页面中引入项目打包生成的js文件
打开项目目录终端，输入命令:

```javascript
npm run dev
```

等待webpack打包完毕之后，找到默认的dist路径中生成的main.js文件，将其引入到html页面中。

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>

在webpack 4.x中，默认会将src/index.js 作为默认的打包入口js文件，默认会将dist/main.js 作为默认的打包输出js文件，如果不想使用默认的入口/出口js文件我们如何设置？<br/><br/>

## 答案
通过设置 webpack.config.js
```javascript
const path = require("path");
module.exports = {
    mode:"development",
    //设置入口文件路径
    entry: path.join(__dirname,"./src/xx.js"),
    //设置出口文件
    output:{
        //设置路径
        path:path.join(__dirname,"./dist"),
        //设置文件名
        filename:"res.js"
    }
}
```


## 选项

### A

通过设置 vue.config.js
```javascript
const path = require("path");
module.exports = {
    mode:"development",
    //设置入口文件路径
    entry: path.join(__dirname,"./src/xx.js"),
    //设置出口文件
    output:{
        //设置路径
        path:path.join(__dirname,"./dist"),
        //设置文件名
        filename:"res.js"
    }
}
```


### B

通过 main.js 中添加下列代码即可
```javascript
const path = require("path");
module.exports = {
    mode:"development",
    //设置入口文件路径
    entry: path.join(__dirname,"./src/xx.js"),
    //设置出口文件
    output:{
        //设置路径
        path:path.join(__dirname,"./dist"),
        //设置文件名
        filename:"res.js"
    }
}
```


### C

不可以设置