# 后置路由守卫

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

**全局后置钩子**
你也可以注册全局后置钩子，然而和守卫不同的是，这些钩子不会接受 next 函数也不会改变导航本身：

```javascript
router.afterEach((to, from) => {
  sendToAnalytics(to.fullPath)
})
```

它们对于分析、更改页面标题、声明页面等辅助功能以及许多其他事情都很有用。

它们也反映了 navigation failures 作为第三个参数：

```javascript
router.afterEach((to, from, failure) => {
  if (!failure) sendToAnalytics(to.fullPath)
})
```
**完整的导航解析流程**
导航被触发。
在失活的组件里调用 beforeRouteLeave 守卫。
调用全局的 beforeEach 守卫。
在重用的组件里调用 beforeRouteUpdate 守卫(2.2+)。
在路由配置里调用 beforeEnter。
解析异步路由组件。
在被激活的组件里调用 beforeRouteEnter。
调用全局的 beforeResolve 守卫(2.5+)。
导航被确认。
调用全局的 afterEach 钩子。
触发 DOM 更新。
调用 beforeRouteEnter 守卫中传给 next 的回调函数，创建好的组件实例会作为回调函数的参数传入。

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>


根据上方资料，以下关于后置路由守卫的说法不正确的是？<br/><br/>

## 答案

router.afterEach  接受next参数

## 选项

### A

不会改变导航本身

### B

接受navigation failures 作为第三个参数

### C

后置路由守卫是异步解析执行，此时导航在所有守卫 resolve 完之前一直处于等待中
