# SSR

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

什么是SSR？

<br>

</br>
Vue.js 是一个用于构建客户端应用程序的框架。默认情况下，Vue 组件在浏览器中生成和操作 DOM 作为输出。但是，也可以在服务器上将相同的组件渲染为 HTML 字符串，直接将它们发送到浏览器，最后将静态标记“水合”成客户端上的完全交互式应用程序。

服务器渲染的 Vue.js 应用程序也可以被认为是“同构的”或“通用的”，因为您的应用程序的大部分代码都在服务器和客户端上运行。
<br><br>

目前我们的vue组件都是在浏览器侧通过js渲染出来的，所以首次加载时间很慢，那么我们把vue组件交给服务端负责渲染，渲染为完整内容之后直接返给客户端，是不是就可以可以解决既想渲染快，还想继续使用vue进行开发的问题了？
<br><br>


为什么选择 SSR？
<br><br>
与客户端单页应用程序（SPA）相比，SSR 的优势主要在于：
<br></br>
更快的内容生成时间：这在慢速互联网或慢速设备上更为突出。服务器渲染的标记不需要等到所有 JavaScript 下载并执行后才显示，因此您的用户将更快地看到完全渲染的页面。此外，初次访问的数据获取是在服务器端完成的，它与您的数据库的连接可能比客户端更快。这通常会导致改进的Core Web Vitals指标、更好的用户体验，并且对于内容时间与转化率直接相关的应用程序至关重要。
<br></br>
统一的思维模型：您可以使用相同的语言和相同的声明式、面向组件的思维模型来开发整个应用程序，而不是在后端模板系统和前端框架之间来回切换。
<br></br>
更好的 SEO：搜索引擎爬虫将直接看到完全呈现的页面。

<br></br>

[vue ssr基础使用](https://ssr.vuejs.org/zh/guide/#%E5%AE%89%E8%A3%85)
<br>
新建vue-ssr文件夹
<br>
```
vue-ssr
```
<br>把server文件夹中的文件拷贝进来<br><br>

<br><br> 安装必要依赖
<br>
```bash
npm install vue vue-server-renderer --save
```
<br>
<br><br> vue服务端渲染最小demo
<br>

`app.js`

<br>

```js
const Vue = require('vue')
const server = require('express')()

const renderer = require('vue-server-renderer').createRenderer()

server.get('*', (req, res) => {
  const app = new Vue({
    data: {
      url: req.url
    },
    template: `<div>访问的 URL 是：{{ url }}</div>`,
  })
  renderer.renderToString(app, (err, html) => {
    if (err) throw err
    res.send(html)
  })
})

server.listen(8888,() => console.log(`Example app listening on port 8888!`))
```
<br><br>
<br>
浏览器访问
<br>
`http://localhost:8888`
<br>
<br>
![在这里插入图片描述](https://img-blog.csdnimg.cn/6df5acdf1be443e38ac1ef7a24e92ddd.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)

<br>
<br><br>查看源代码
<br>

![在这里插入图片描述](https://img-blog.csdnimg.cn/59c8621bee034e2980cddc71ccee5cfc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)

<br>


<br>
结论：我们通过在服务器端渲染vue组件的方式，让网页中又有了完整的内容，这样我们就可以既使用了vue开发又节省了首次渲染时间



<br><br></br>




 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>

下面对于服务端渲染和客户端渲染描述不正确的是？ <br/><br/>

## 答案

服务端渲染的用户体验一定优于客户端渲染

## 选项

### A

通过vue-cli，create-react-app 等工具创建的项目是服务端渲染的

### B

服务端渲染对SEO更加友好，而且首屏渲染通常更快一些

### C

SPA是客户端渲染的