# webpack的相关配置

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

**设置webpack的打包入口/出口**
<br>
在webpack 4.x中，默认会将src/index.js 作为默认的打包入口js文件，默认会将dist/main.js 作为默认的打包输出js文件，如果不想使用默认的入口/出口js文件，我们可以通过改变 webpack.config.js 来设置入口/出口的js文件，如下：

```javascript
const path = require("path");
module.exports = {
    mode:"development",
    //设置入口文件路径
    entry: path.join(__dirname,"./src/xx.js"),
    //设置出口文件
    output:{
        //设置路径
        path:path.join(__dirname,"./dist"),
        //设置文件名
        filename:"res.js"
    }
}
```

**设置webpack的自动打包**
<br>
默认情况下，我们更改入口js文件的代码，需要重新运行命令打包webpack，才能生成出口的js文件，那么每次都要重新执行命令打包，这是一个非常繁琐的事情，那么，自动打包可以解决这样繁琐的操作。实现自动打包功能的步骤如下：
<br>
1.安装自动打包功能的包:webpack-dev-server
>npm install webpack-dev-server -D
>
2.修改package.json中的dev指令如下：

```javascript
"scripts":{
            "dev":"webpack-dev-server"
        }
```

3.将引入的js文件路径更改为：

```javascript
<script src="/bundle.js"></script>
```

4.运行npm run dev，进行打包
<br>
5.打开网址查看效果：http://localhost:8080

<br>
**注意：**
webpack-dev-server自动打包的输出文件，默认放到了服务器的根目录中。
**补充：**
在自动打包完毕之后，默认打开服务器网页，实现方式就是打开package.json文件，修改dev命令：
```javascript
 "dev": "webpack-dev-server --open --host 127.0.0.1 --port 9999"
```
**配置html-webpack-plugin**
<br>

>使用html-webpack-plugin 可以生成一个预览页面。

因为当我们访问默认的 http://localhost:8080/的时候，看到的是一些文件和文件夹，想要查看我们的页面,还需要点击文件夹点击文件才能查看，那么我们希望默认就能看到一个页面，而不是看到文件夹或者目录。

<br>
实现默认预览页面功能的步骤如下：
<br>
1.安装默认预览功能的包:html-webpack-plugin
<br>

>npm install html-webpack-plugin -D

2.修改webpack.config.js文件，如下：

```javascript
//导入包
        const HtmlWebpackPlugin = require("html-webpack-plugin");
        //创建对象
        const htmlPlugin = new HtmlWebpackPlugin({
            //设置生成预览页面的模板文件
            template:"./src/index.html",
            //设置生成的预览页面名称
            filename:"index.html"
        })
```
3.继续修改webpack.config.js文件，添加plugins信息：

```javascript
module.exports = {
            ......
            plugins:[ htmlPlugin ]
        }
```
**webpack中的加载器**
<br>
通过loader打包非js模块：默认情况下，webpack只能打包js文件，如果想要打包非js文件，需要调用loader加载器才能打包
<br>
    loader加载器包含：
        1).less-loader
        2).sass-loader
        3).url-loader:打包处理css中与url路径有关的文件
        4).babel-loader:处理高级js语法的加载器
        5).postcss-loader
        6).css-loader,style-loader

<br>
注意：指定多个loader时的顺序是固定的，而调用loader的顺序是从后向前进行调用



<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>

如果项目中处理css需要安装?<br/><br/>

## 答案

css-loader、style-loader

## 选项

### A

style-loader、sass-loder

### B

sass-loader

### C
css-loader、sass-loder
