# 请求跨域

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

首先大家来看一张图片<br/>
![在这里插入图片描述](https://img-blog.csdnimg.cn/58c82a3d34d943aea9d560187ae0e461.png)
<br/>
相信上面这张图片大家都不陌生，这就是我们的跨域问题，为什么会出现跨域请求呢？我们先来了解一下浏览器的同源：

<br>
同源策略（Same origin policy）是一种约定，它是浏览器最核心也最基本的安全功能，如果缺少了同源策略，则浏览器的正常功能可能都会受到影响。可以说 Web 是构建在同源策略基础之上的，浏览器只是针对同源策略的一种实现。
<br>
它的核心就在于它认为自任何站点装载的信赖内容是不安全的。当被浏览器半信半疑的脚本运行在沙箱时，它们应该只被允许访问来自同一站点的资源，而不是那些来自其它站点可能怀有恶意的资源。

<br>
所谓同源是指：域名、协议、端口相同。其中一项不相同则就是非同源就会出现跨域！

<br>
在Vue中我们常用proxy来解决跨域问题
这里我们以cli3为例
vue.config.js中配置代理，vue.config.js文件是在项目的根目录下 如果没有可以自行创建。
<br>
![在这里插入图片描述](https://img-blog.csdnimg.cn/fb86a8b4ad0846288365faa6ea41df81.png)
<br>

```javascript
// 配置
module.exports = {
    publicPath: './',
    filenameHashing: true,
    productionSourceMap: false,
    outputDir: process.env.outputDir,
    // chunkFilename: 'js/[chunkname].[chunkhash].chunk.js',
    pages: obj,
    devServer: {
        proxy: {
            '/zss': {
                target: 'http://172.18.18.995:10000/', 
                changeOrigin: true,
                pathRewrite: {
                    '^/zss': '/zss'
                }
            },

            '/vidVisNew': {
                target: 'http://172.18.18.669:9180',
                changeOrigin: true,
                pathRewrite: {
                    '^/vidVisNew': ''
                }
            }
        }
    },
};
```
上面这个代理能够生效的前提条件是需要我们在创建Axios的时候需要配置`BASE_URL`

```javascript

const zssHttp = axios.create({
  timeout: 1000 * 100000,
  withCredentials: true,
  BASE_URL: '/zss'
  headers: {
     'Content-Type': 'application/json; charset=utf-8'
   }
})
```
大家应该可以看出了，我们这里的BASE_URL如果设置为 `/zss`那么就会在vue.config.js中的被代理到`http://172.18.18.995:10000/`服务，这就是我们vue在开发环境中的代理哦，其实解决跨域问题有很多中方式，大家找到最适合自己项目的即可

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>
 
下面是两种解决跨域问题的方案，请选择下文中缺失的正确关键字?
1)CORS解决跨域问题，这需要通过后端来解决，通过设置header头`(__1__)`来通配。使服务器允许跨域请求接口数据，而前端正常使用axios请求方式。
2)通过接口代理的方式，在vue项目中创建一个vue.config.js，导入一个`(__2__)`，并配置里面的`(__3__)`选项即可。<br/><br/>

## 答案

1、Access-Control-Allow-Origin；2、devServe；3、proxy

## 选项

### A

1、Access；2、devServe；3、CrossDomain

### B

1、Access-Control-Allow-Origin；2、devServe；3、CrossDomain

### C

1、Access；2、devServe；3、proxy

