# 非父子组件通讯

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>

**原理：**<br>
> 通过一个Vue实例来传递数据

const bus =new Vue()

**核心逻辑：**<br>
>组件A给组件B传值： 
>1. 组件A给bus注册一个事件，监听事件的处理程序 
>2. 组件B触发bus上对应的事件，把 值当成参数来传递
>3. 组件A通过事件处理程序获取数据
>
<br/>![在这里插入图片描述](https://img-blog.csdnimg.cn/20200403124524548.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0pIWExf,size_16,color_FFFFFF,t_70)
<br/>
**最终点击h2控制台会输出2**<br>
1. 创建1和2两个非父子组件以及vue实例bus
2. 在1组件中 钩子函数created中通过**bus.$on**为bus自定义一个事件aa 
3. 在2组件中 当点击h2元素时触发dian函数 并且将值出过去
4. 在2组件的dian函数中通过**bus.$emit**方触发1中的aa事件 并传参过去 
5. 当1中的aa事件被触发时会执行其中的函数并获取参数


**通过非父子组件 实现开关灯案例**<br>

关闭状态：
<br/>![在这里插入图片描述](https://img-blog.csdnimg.cn/20200403125323123.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0pIWExf,size_16,color_FFFFFF,t_70)
<br/>
开启状态：
<br/>![在这里插入图片描述](https://img-blog.csdnimg.cn/20200403125354722.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0pIWExf,size_16,color_FFFFFF,t_70)
<br/>
**代码如下**

```
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <style>
        #app {
            width: 500px;
            height: 500px;
            margin: 100px auto;
        }

        .box {
            height: 200px;
            width: 200px;
            margin: 0 auto;
            background-color: black;
            border-radius: 50%;
        }

        .below {
            height: 200px;
            width: 400px;
            margin: 50px auto;
        }

        button {
            margin-left: 66px;
            width: 100px;
            height: 40px;
        }

        .on {
            background-color: rgb(160, 184, 25);
        }
    </style>
</head>

<body>
    <div id="app">
        <zss></zss>
        <sgy></sgy>
    </div>
    <script src="./node_modules/vue/dist/vue.js"></script>
    <script>
        const bus = new Vue()
        Vue.component('zss', {
            data() {
                return {
                    attribute: "on",
                    state: false
                }
            },
            created() {
                bus.$on('lamp', result => {
                    this.state = result
                })
            },
            template: `<div class="box" :class="state?attribute:''"></div>`
        })
        Vue.component('sgy', {
            template: `<div class="below">
                        <button @click="on">开灯</button>
                        <button @click="off">关闭</button>
                      </div>`,
            methods: {
                on() {
                    bus.$emit('lamp', true)
                },
                off() {
                    bus.$emit('lamp', false)
                }
            }
        })
        const app = new Vue({
            el: '#app',
            data: {

            }
        })
    </script>
</body>

</html>
```

**非父子组件不仅这一种通讯方式，其他方式同学们可以去博文中查看**

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>




下列关于非父子组件通讯描述正确的是？<br/><br/>

## 答案

eventBus其实就是当触发事件时，发送一个通知出去，在需要响应的地方接收这个通知，响应事件。

## 选项

### A

eventBus是非父子组件通讯唯一方式。

### B

非父子组件之间进行通讯会造成内存泄漏。

### C

VueX并不能解决非父子通讯问题。
